/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.test;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.swing.EmptyReplacedElement;
import org.xhtmlrenderer.swing.ImageReplacedElement;
import org.xhtmlrenderer.test.ElementReplacer;
import org.xhtmlrenderer.util.ImageUtil;
import org.xhtmlrenderer.util.XRLog;

@ParametersAreNonnullByDefault
public class SwingImageReplacer
extends ElementReplacer {
    private static final Logger log = LoggerFactory.getLogger(SwingImageReplacer.class);
    private final Map<Element, ReplacedElement> imageComponents = new HashMap<Element, ReplacedElement>();

    @Override
    public boolean isElementNameMatch() {
        return true;
    }

    @Override
    public String getElementNameMatch() {
        return "img";
    }

    @Override
    public boolean accept(LayoutContext context, Element element) {
        return context.getNamespaceHandler().isImageElement(element);
    }

    @Override
    public ReplacedElement replace(LayoutContext context, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        return this.replaceImage(uac, context, box.getElement(), cssWidth, cssHeight);
    }

    @Override
    public void clear(Element element) {
        log.info("cleared image components for element {}", (Object)element);
        this.imageComponents.remove(element);
    }

    @Override
    public void reset() {
        log.info("cleared image components");
        this.imageComponents.clear();
    }

    protected ReplacedElement replaceImage(UserAgentCallback uac, LayoutContext context, Element elem, int cssWidth, int cssHeight) {
        ReplacedElement re = this.lookupImageReplacedElement(elem);
        if (re == null) {
            BufferedImage im = null;
            String imageSrc = context.getNamespaceHandler().getImageSourceURI(elem);
            if (imageSrc == null || imageSrc.isEmpty()) {
                XRLog.layout(Level.WARNING, "No source provided for img element.");
                re = this.newIrreplaceableImageElement(cssWidth, cssHeight);
            } else {
                FSImage fsImage = uac.getImageResource(imageSrc).getImage();
                if (fsImage != null) {
                    im = ((AWTFSImage)fsImage).getImage();
                }
                re = im != null ? new ImageReplacedElement(im, cssWidth, cssHeight) : this.newIrreplaceableImageElement(cssWidth, cssHeight);
            }
            this.storeImageReplacedElement(elem, re);
        }
        return re;
    }

    protected void storeImageReplacedElement(Element e, ReplacedElement cc) {
        log.info("\nCached image for element");
        this.imageComponents.put(e, cc);
    }

    protected ReplacedElement lookupImageReplacedElement(Element e) {
        return this.imageComponents.get(e);
    }

    protected ReplacedElement newIrreplaceableImageElement(int cssWidth, int cssHeight) {
        try {
            BufferedImage missingImage = ImageUtil.createCompatibleBufferedImage(cssWidth, cssHeight, 1);
            ImageUtil.withGraphics(missingImage, g -> {
                g.setColor(Color.BLACK);
                g.setBackground(Color.WHITE);
                g.setFont(new Font("Serif", 0, 12));
                g.drawString("Missing", 0, 12);
            });
            return new ImageReplacedElement(missingImage, cssWidth, cssHeight);
        }
        catch (Exception e) {
            log.error("Failed to create image element of size %sx%s".formatted(cssWidth, cssHeight), (Throwable)e);
            return new EmptyReplacedElement(Math.max(cssWidth, 0), Math.max(cssHeight, 0));
        }
    }
}

