/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.xhtmlrenderer.pdf.ITextRenderer;

@ParametersAreNonnullByDefault
public class PDFRenderer {
    private static final Map<String, Character> versionMap = new HashMap<String, Character>();

    public static void renderToPDF(String url, String pdf) throws IOException, DocumentException {
        PDFRenderer.renderToPDF(url, pdf, null);
    }

    public static void renderToPDF(String url, String pdf, @Nullable Character pdfVersion) throws IOException, DocumentException {
        ITextRenderer renderer = ITextRenderer.fromUrl(url);
        if (pdfVersion != null) {
            renderer.setPDFVersion(pdfVersion.charValue());
        }
        PDFRenderer.doRenderToPDF(renderer, pdf);
    }

    public static void renderToPDF(File file, String pdf) throws IOException, DocumentException {
        PDFRenderer.renderToPDF(file, pdf, null);
    }

    public static void renderToPDF(File file, String pdf, @Nullable Character pdfVersion) throws IOException, DocumentException {
        ITextRenderer renderer = new ITextRenderer(file);
        if (pdfVersion != null) {
            renderer.setPDFVersion(pdfVersion.charValue());
        }
        PDFRenderer.doRenderToPDF(renderer, pdf);
    }

    private static void doRenderToPDF(ITextRenderer renderer, String pdf) throws IOException, DocumentException {
        try (OutputStream os = Files.newOutputStream(Paths.get(pdf, new String[0]), new OpenOption[0]);){
            renderer.layout();
            renderer.createPDF(os);
        }
    }

    public static void main(String[] args) throws IOException, DocumentException {
        String url;
        if (args.length < 2) {
            PDFRenderer.usage("Incorrect argument list.");
        }
        Character pdfVersion = null;
        if (args.length == 3) {
            pdfVersion = PDFRenderer.checkVersion(args[2]);
        }
        if (!(url = args[0]).contains("://")) {
            File f = new File(url);
            if (f.exists()) {
                PDFRenderer.renderToPDF(f, args[1], pdfVersion);
            } else {
                PDFRenderer.usage("File to render is not found: " + url);
            }
        } else {
            PDFRenderer.renderToPDF(url, args[1], pdfVersion);
        }
    }

    private static Character checkVersion(String version) {
        Character val = versionMap.get(version.trim());
        if (val == null) {
            PDFRenderer.usage("Invalid PDF version number; use 1.2 through 1.7");
        }
        return val;
    }

    private static void usage(@Nullable String err) {
        if (err != null && !err.isEmpty()) {
            System.err.println("==>" + err);
        }
        System.err.println("Usage: ... url pdf [version]");
        System.err.println("   where version (optional) is between 1.2 and 1.7");
        System.exit(1);
    }

    static {
        versionMap.put("1.2", Character.valueOf('2'));
        versionMap.put("1.3", Character.valueOf('3'));
        versionMap.put("1.4", Character.valueOf('4'));
        versionMap.put("1.5", Character.valueOf('5'));
        versionMap.put("1.6", Character.valueOf('6'));
        versionMap.put("1.7", Character.valueOf('7'));
    }
}

