/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.infinispan.internal;

import org.apache.commons.lang3.StringUtils;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.util.AbstractCacheConfigurationLoader;
import org.xwiki.environment.Environment;

public class InfinispanConfigurationLoader
extends AbstractCacheConfigurationLoader {
    public static final String CONFX_EXPIRATION_WAKEUPINTERVAL = "infinispan.expiration.wakeupinterval";
    private static final String DEFAULT_SINGLEFILESTORE_LOCATION = "Infinispan-SingleFileStore";

    public InfinispanConfigurationLoader(CacheConfiguration configuration, Environment environment) {
        super(configuration, environment, null);
    }

    private ConfigurationBuilder builder(ConfigurationBuilder builder, Configuration isconfiguration) {
        if (builder != null) {
            return builder;
        }
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        if (isconfiguration != null) {
            newBuilder.read(isconfiguration);
        }
        return newBuilder;
    }

    private boolean containsIncompleteFileLoader(Configuration isconfiguration) {
        PersistenceConfiguration persistenceConfiguration = isconfiguration.persistence();
        for (StoreConfiguration storeConfiguration : persistenceConfiguration.stores()) {
            SingleFileStoreConfiguration singleFileStoreConfiguration;
            String location;
            if (!(storeConfiguration instanceof SingleFileStoreConfiguration) || !StringUtils.isBlank((CharSequence)(location = (singleFileStoreConfiguration = (SingleFileStoreConfiguration)storeConfiguration).location())) && !location.equals(DEFAULT_SINGLEFILESTORE_LOCATION)) continue;
            return true;
        }
        return false;
    }

    private ConfigurationBuilder customizeEviction(ConfigurationBuilder currentBuilder, Configuration configuration) {
        ConfigurationBuilder builder = currentBuilder;
        EntryEvictionConfiguration eec = (EntryEvictionConfiguration)this.getCacheConfiguration().get((Object)"eviction");
        if (eec != null && eec.getAlgorithm() == EntryEvictionConfiguration.Algorithm.LRU) {
            builder = this.customizeEvictionMaxEntries(builder, configuration, eec);
            builder = this.customizeExpirationWakeUpInterval(builder, configuration, eec);
            builder = this.customizeExpirationMaxIdle(builder, configuration, eec);
            builder = this.customizeExpirationLifespan(builder, configuration, eec);
        }
        return builder;
    }

    private ConfigurationBuilder customizeEvictionMaxEntries(ConfigurationBuilder currentBuilder, Configuration configuration, EntryEvictionConfiguration eec) {
        ConfigurationBuilder builder = currentBuilder;
        if (eec.containsKey((Object)"maxentries")) {
            int maxEntries = ((Number)eec.get((Object)"maxentries")).intValue();
            if (configuration.eviction() == null || configuration.eviction().strategy() != EvictionStrategy.LRU || configuration.eviction().maxEntries() != (long)maxEntries) {
                builder = this.builder(builder, null);
                builder.eviction().strategy(EvictionStrategy.LRU);
                builder.eviction().type(EvictionType.COUNT).size((long)maxEntries);
            }
        }
        return builder;
    }

    private ConfigurationBuilder customizeExpirationWakeUpInterval(ConfigurationBuilder currentBuilder, Configuration configuration, EntryEvictionConfiguration eec) {
        ConfigurationBuilder builder = currentBuilder;
        if (eec.get((Object)CONFX_EXPIRATION_WAKEUPINTERVAL) instanceof Number) {
            builder = this.builder(builder, null);
            builder.expiration().wakeUpInterval(((Number)eec.get((Object)CONFX_EXPIRATION_WAKEUPINTERVAL)).longValue());
        }
        return builder;
    }

    private ConfigurationBuilder customizeExpirationMaxIdle(ConfigurationBuilder currentBuilder, Configuration configuration, EntryEvictionConfiguration eec) {
        ConfigurationBuilder builder = currentBuilder;
        if (eec.getTimeToLive() > 0) {
            long maxIdle = (long)eec.getTimeToLive() * 1000L;
            if (configuration.expiration() == null || configuration.expiration().maxIdle() != maxIdle) {
                builder = this.builder(builder, null);
                builder.expiration().maxIdle((long)eec.getTimeToLive() * 1000L);
            }
        }
        return builder;
    }

    private ConfigurationBuilder customizeExpirationLifespan(ConfigurationBuilder currentBuilder, Configuration configuration, EntryEvictionConfiguration eec) {
        ConfigurationBuilder builder = currentBuilder;
        if (eec.containsKey((Object)"lifespan")) {
            long lifespan = (long)((Integer)eec.get((Object)"lifespan")).intValue() * 1000L;
            if (configuration.expiration() == null || configuration.expiration().lifespan() != lifespan) {
                builder = this.builder(builder, null);
                builder.expiration().lifespan(lifespan);
            }
        }
        return builder;
    }

    private ConfigurationBuilder completeFilesystem(ConfigurationBuilder currentBuilder, Configuration configuration) {
        ConfigurationBuilder builder = currentBuilder;
        if (this.containsIncompleteFileLoader(configuration)) {
            builder = this.builder(builder, configuration);
            PersistenceConfigurationBuilder persistence = builder.persistence();
            persistence.clearStores();
            for (StoreConfiguration storeConfiguration : configuration.persistence().stores()) {
                if (storeConfiguration instanceof SingleFileStoreConfiguration) {
                    SingleFileStoreConfiguration singleFileStoreConfiguration = (SingleFileStoreConfiguration)storeConfiguration;
                    String location = singleFileStoreConfiguration.location();
                    if (!StringUtils.isBlank((CharSequence)location) && !location.equals(DEFAULT_SINGLEFILESTORE_LOCATION)) continue;
                    SingleFileStoreConfigurationBuilder singleFileStoreConfigurationBuilder = persistence.addSingleFileStore();
                    singleFileStoreConfigurationBuilder.read(singleFileStoreConfiguration);
                    singleFileStoreConfigurationBuilder.location(this.createTempDir());
                    continue;
                }
                Class storeBuilderClass = ConfigurationUtils.builderFor((Object)storeConfiguration);
                StoreConfigurationBuilder storeBuilder = persistence.addStore(storeBuilderClass);
                storeBuilder.read((Object)storeConfiguration);
            }
        }
        return builder;
    }

    public Configuration customize(Configuration defaultConfiguration, Configuration namedConfiguration) {
        ConfigurationBuilder builder = null;
        if (namedConfiguration == null) {
            builder = this.customizeEviction(builder, defaultConfiguration);
        }
        if (namedConfiguration != null) {
            builder = this.completeFilesystem(builder, namedConfiguration);
        }
        return builder != null ? builder.build() : null;
    }
}

