/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.collection;

import java.lang.ref.SoftReference;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SoftCache<K, V> {
    private WeakHashMap<K, SoftReference<V>> map = new WeakHashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        this.lock.readLock().lock();
        try {
            SoftReference<V> reference = this.map.get(key);
            V v = reference != null ? (V)reference.get() : null;
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public V get(K key, V defaultValue) {
        V sharedValue = this.get(key);
        if (sharedValue == null) {
            sharedValue = defaultValue;
            this.put(key, defaultValue);
        }
        return sharedValue;
    }

    public void put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.map.put(key, new SoftReference<V>(value));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

