/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.beanutils.ConvertUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.internal.AbstractConfigurationSource;

@Component
@Singleton
@Named(value="memory")
public class MemoryConfigurationSource
extends AbstractConfigurationSource {
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public <T> T getProperty(String key, T defaultValue) {
        Object result;
        if (this.properties.containsKey(key)) {
            Object value = this.properties.get(key);
            if (value != null && defaultValue != null && !defaultValue.getClass().isInstance(value)) {
                value = ConvertUtils.convert((Object)value, defaultValue.getClass());
            }
            result = value;
        } else {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public <T> T getProperty(String key, Class<T> valueClass) {
        Object result;
        if (this.properties.containsKey(key)) {
            Object value = this.properties.get(key);
            if (value != null && valueClass != null && !valueClass.isInstance(value)) {
                value = ConvertUtils.convert((Object)value, valueClass);
            }
            result = value;
        } else {
            result = this.getDefault(valueClass);
        }
        return result;
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    @Override
    public List<String> getKeys() {
        return new ArrayList<String>(this.properties.keySet());
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }
}

