/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.context.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextInitializer;
import org.xwiki.context.ExecutionContextManager;

@Component
@Singleton
public class DefaultExecutionContextManager
implements ExecutionContextManager {
    @Inject
    private List<ExecutionContextInitializer> initializers = new ArrayList<ExecutionContextInitializer>();

    public ExecutionContext clone(ExecutionContext context) throws ExecutionContextException {
        ExecutionContext clonedContext = new ExecutionContext();
        this.initialize(clonedContext);
        clonedContext.setProperty("xwikicontext", context.getProperty("xwikicontext"));
        Object velocityContext = context.getProperty("velocityContext");
        if (velocityContext != null) {
            try {
                clonedContext.setProperty("velocityContext", velocityContext.getClass().getMethod("clone", new Class[0]).invoke(velocityContext, new Object[0]));
            }
            catch (Exception e) {
                throw new ExecutionContextException("Failed to clone Velocity Context for the new Execution Context", e);
            }
        }
        return clonedContext;
    }

    public void initialize(ExecutionContext context) throws ExecutionContextException {
        for (ExecutionContextInitializer initializer : this.initializers) {
            initializer.initialize(context);
        }
    }

    public void addExecutionContextInitializer(ExecutionContextInitializer initializer) {
        this.initializers.add(initializer);
    }
}

