/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.context.internal;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;

public class ExecutionContextProperty
implements Cloneable {
    private final String key;
    private Object value;
    private final boolean cloneValue;
    private final boolean isFinal;
    private final boolean inherited;
    private final boolean nonNull;
    private final Class<?> type;
    private WeakReference<ExecutionContextProperty> clonedFrom;

    public ExecutionContextProperty(String key, Object initialValue, boolean cloneValue, boolean isFinal, boolean inherited, boolean nonNull, Class<?> type) {
        this.key = key;
        this.value = initialValue;
        this.cloneValue = cloneValue;
        this.isFinal = isFinal;
        this.inherited = inherited;
        this.nonNull = nonNull;
        this.type = type;
        this.checkValue(initialValue);
    }

    private void checkValue(Object value) {
        if (this.nonNull && value == null) {
            throw new IllegalArgumentException(String.format("The property [%s] may not be null!", this.getKey()));
        }
        if (this.getType() != null && value != null && !this.getType().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(String.format("The value of property [%s] must be of type [%s], but was [%s]", this.getKey(), this.getType(), value.getClass()));
        }
    }

    public void setValue(Object value) {
        this.checkValue(value);
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    private Class<?> getType() {
        return this.type;
    }

    public ExecutionContextProperty clone() {
        Object clonedValue;
        if (this.cloneValue) {
            try {
                clonedValue = this.getValue().getClass().getMethod("clone", new Class[0]).invoke(this.getValue(), new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(String.format("cloneValue attribute was set on property [%s], but the value had class [%s] which has no public clone method", this.getKey(), this.getValue().getClass().getName()));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        } else {
            clonedValue = this.getValue();
        }
        ExecutionContextProperty clone = new ExecutionContextProperty(this.getKey(), clonedValue, this.cloneValue, this.isFinal(), this.isInherited(), this.nonNull, this.getType());
        if (this.isFinal() && this.isInherited()) {
            clone.clonedFrom = new WeakReference<ExecutionContextProperty>(this);
        }
        return clone;
    }

    public boolean isClonedFrom(ExecutionContextProperty property) {
        return this.clonedFrom != null && this.clonedFrom.get() == property;
    }
}

