/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.params.generator.asymmetric;

import java.math.BigInteger;
import org.xwiki.crypto.params.generator.KeyGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DHKeyValidationParameters;

public class DHKeyGenerationParameters
implements KeyGenerationParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 20;
    private final BigInteger p;
    private final BigInteger g;
    private final BigInteger q;
    private final int l;
    private final int m;
    private final BigInteger j;
    private final DHKeyValidationParameters parameters;

    public DHKeyGenerationParameters(BigInteger p, BigInteger g) {
        this(p, g, null, 0);
    }

    public DHKeyGenerationParameters(BigInteger p, BigInteger g, BigInteger q) {
        this(p, g, q, 0);
    }

    public DHKeyGenerationParameters(BigInteger p, BigInteger g, BigInteger q, int l) {
        this(p, g, q, DHKeyGenerationParameters.getDefaultM(l), l, null, null);
    }

    public DHKeyGenerationParameters(BigInteger p, BigInteger g, BigInteger q, int m, int l) {
        this(p, g, q, m, l, null, null);
    }

    public DHKeyGenerationParameters(BigInteger p, BigInteger g, BigInteger q, BigInteger j, DHKeyValidationParameters parameters) {
        this(p, g, q, 20, 0, j, parameters);
    }

    public DHKeyGenerationParameters(BigInteger p, BigInteger g, BigInteger q, int m, int l, BigInteger j, DHKeyValidationParameters parameters) {
        this.p = p;
        this.g = g;
        this.q = q;
        this.m = m;
        this.l = l;
        this.parameters = parameters;
        this.j = j;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public DHKeyValidationParameters getValidationParameters() {
        return this.parameters;
    }

    private static int getDefaultM(int l) {
        if (l == 0) {
            return 20;
        }
        return l < 20 ? l : 20;
    }
}

