/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.params.generator.asymmetric;

import org.xwiki.crypto.params.generator.KeyGenerationParameters;
import org.xwiki.crypto.params.generator.KeyParametersGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DSAKeyValidationParameters;
import org.xwiki.crypto.params.generator.symmetric.GenericKeyGenerationParameters;

public class DSAKeyParametersGenerationParameters
extends GenericKeyGenerationParameters
implements KeyParametersGenerationParameters,
KeyGenerationParameters {
    private static final int DEFAULT_STRENGTH = 128;
    private static final int DEFAULT_CERTAINTY = 20;
    private final boolean use186r3;
    private final int certainty;
    private final int nSize;
    private final DSAKeyValidationParameters.Usage usage;
    private final String digest;

    public DSAKeyParametersGenerationParameters() {
        this(128, 20);
    }

    public DSAKeyParametersGenerationParameters(int lsize) {
        this(lsize, 20);
    }

    public DSAKeyParametersGenerationParameters(int lsize, int certainty) {
        this(false, lsize, -1, certainty, DSAKeyValidationParameters.Usage.ANY, DSAKeyParametersGenerationParameters.getDigestHint(DSAKeyParametersGenerationParameters.getDefaultNsize(lsize)));
    }

    public DSAKeyParametersGenerationParameters(int lsize, int nsize, int certainty) {
        this(lsize, nsize, certainty, DSAKeyValidationParameters.Usage.ANY);
    }

    public DSAKeyParametersGenerationParameters(int lsize, int nsize, int certainty, DSAKeyValidationParameters.Usage usage) {
        this(true, lsize, nsize, certainty, usage, DSAKeyParametersGenerationParameters.getDigestHint(nsize));
    }

    public DSAKeyParametersGenerationParameters(int lsize, int nsize, int certainty, DSAKeyValidationParameters.Usage usage, String hashHint) {
        this(true, lsize, nsize, certainty, usage, hashHint);
    }

    private DSAKeyParametersGenerationParameters(boolean use186r3, int lsize, int nsize, int certainty, DSAKeyValidationParameters.Usage usage, String digest) {
        super(lsize);
        this.certainty = certainty;
        this.nSize = nsize;
        this.usage = usage;
        this.use186r3 = use186r3;
        this.digest = digest;
    }

    private static int getDefaultNsize(int lSize) {
        return lSize > 128 ? 32 : 20;
    }

    private static String getDigestHint(int nSize) {
        if (nSize <= 20) {
            return "SHA-1";
        }
        if (nSize <= 28) {
            return "SHA-224";
        }
        if (nSize <= 32) {
            return "SHA-256";
        }
        if (nSize <= 48) {
            return "SHA-384";
        }
        return "SHA-512";
    }

    public boolean use186r3() {
        return this.use186r3;
    }

    public int getPrimePsize() {
        return this.getStrength();
    }

    public int getPrimeQsize() {
        return this.nSize;
    }

    public int getCertainty() {
        return this.certainty;
    }

    public DSAKeyValidationParameters.Usage getUsage() {
        return this.usage;
    }

    public String getHashHint() {
        return this.digest;
    }
}

