/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.signer.param.CMSSignedDataVerified;
import org.xwiki.crypto.signer.param.CMSSignerVerifiedInformation;

public class BcCMSSignedDataVerified
implements CMSSignedDataVerified {
    private final Collection<CMSSignerVerifiedInformation> signatures = new ArrayList<CMSSignerVerifiedInformation>();
    private final Collection<CertifiedPublicKey> certificates = new ArrayList<CertifiedPublicKey>();
    private final String contentType;
    private final byte[] content;

    BcCMSSignedDataVerified(String contentType, byte[] content) {
        this.contentType = contentType;
        this.content = content;
    }

    void addCertificate(CertifiedPublicKey certificate) {
        this.certificates.add(certificate);
    }

    void addSignature(CMSSignerVerifiedInformation signature) {
        this.signatures.add(signature);
    }

    @Override
    public Collection<CMSSignerVerifiedInformation> getSignatures() {
        return Collections.unmodifiableCollection(this.signatures);
    }

    @Override
    public Collection<CertifiedPublicKey> getCertificates() {
        return Collections.unmodifiableCollection(this.certificates);
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public boolean isVerified() {
        boolean result = !this.signatures.isEmpty();
        for (CMSSignerVerifiedInformation signature : this.signatures) {
            if (!(result &= signature.isVerified())) break;
        }
        return result;
    }
}

