/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.crypto.pkix;

import org.xwiki.component.annotation.Role;
import org.xwiki.crypto.pkix.params.CertificateGenerationParameters;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.stability.Unstable;

/**
 * Factory of Certificate Generator.
 *
 * @version $Id: 5e6a786d4a7c44b31ac4058f7490d2b67b217df7 $
 * @since 5.4
 */
@Role
@Unstable
public interface CertificateGeneratorFactory
{
    /**
     * Create a initialized certificate generator.
     *
     * @param signer a certifying signer initialized with the certified key pair of the issuer
     *               or a signer initialized with the private key of the subject for creating a self sign certificate.
     * @param parameters the common parameters for all certificate generated by this generator.
     * @return a certificate generator.
     */
    CertificateGenerator getInstance(Signer signer, CertificateGenerationParameters parameters);
}
