/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.io.IOException;
import java.security.SecureRandom;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.internal.AbstractBcX509CertificateGenerator;
import org.xwiki.crypto.pkix.internal.BcX509TBSCertificateBuilder;
import org.xwiki.crypto.pkix.internal.BcX509v3TBSCertificateBuilder;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.PrincipalIndentifier;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertificateParameters;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Extensions;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;

public class BcX509v3CertificateGenerator
extends AbstractBcX509CertificateGenerator {
    private final X509Extensions extensions;

    public BcX509v3CertificateGenerator(Signer signer, X509CertificateGenerationParameters parameters, SignerFactory signerFactory, SecureRandom random) {
        super(signer, parameters, signerFactory, random);
        this.extensions = parameters.getExtensions();
    }

    @Override
    protected BcX509TBSCertificateBuilder getTBSCertificateBuilder() {
        return new BcX509v3TBSCertificateBuilder();
    }

    @Override
    protected void extendsTBSCertificate(BcX509TBSCertificateBuilder builder, CertifiedPublicKey issuer, PrincipalIndentifier subjectName, PublicKeyParameters subject, X509CertificateParameters parameters) throws IOException {
        BcX509v3TBSCertificateBuilder bld = (BcX509v3TBSCertificateBuilder)builder;
        if (issuer != null) {
            bld.setExtensions(issuer, subject, this.extensions, parameters.getExtensions());
        } else {
            bld.setExtensions(subject, this.extensions, parameters.getExtensions());
        }
    }
}

