/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.params;

import org.xwiki.stability.Unstable;

@Unstable
public class PssParameters {
    private static final String DEFAULT_DIGEST = "SHA-1";
    private static final byte TRAILER_1 = -68;
    private final String hashAlgorithm;
    private final String maskGenAlgorithm;
    private final int saltLength;
    private final int trailerField;

    public PssParameters() {
        this(DEFAULT_DIGEST);
    }

    public PssParameters(String hashAlgorithm) {
        this(hashAlgorithm, -1);
    }

    public PssParameters(String hashAlgorithm, int saltLength) {
        this(hashAlgorithm, hashAlgorithm, saltLength, 1);
    }

    public PssParameters(String hashAlgorithm, String maskGenAlgorithm, int saltLength) {
        this(hashAlgorithm, maskGenAlgorithm, saltLength, 1);
    }

    public PssParameters(String hashAlgorithm, String maskGenAlgorithm, int saltLength, int trailerField) {
        this.hashAlgorithm = hashAlgorithm;
        this.maskGenAlgorithm = maskGenAlgorithm;
        this.saltLength = saltLength;
        this.trailerField = trailerField;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getMaskGenAlgorithm() {
        return this.maskGenAlgorithm;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public int getTrailerField() {
        return this.trailerField;
    }

    public byte getTrailerByte() {
        if (this.trailerField == 1) {
            return -68;
        }
        throw new IllegalArgumentException("Unknown trailer field.");
    }
}

