/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.xwiki.diff.Delta;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.Patch;
import org.xwiki.diff.PatchException;
import org.xwiki.diff.internal.AbstractDelta;
import org.xwiki.diff.internal.ChangeDelta;
import org.xwiki.diff.internal.DeleteDelta;
import org.xwiki.diff.internal.InsertDelta;

public class DefaultPatch<E>
extends LinkedList<Delta<E>>
implements Patch<E> {
    private static final long serialVersionUID = 1L;

    public DefaultPatch() {
    }

    public DefaultPatch(difflib.Patch<E> patch) throws DiffException {
        for (difflib.Delta delta : patch.getDeltas()) {
            this.add(this.toDelta(delta));
        }
    }

    private Delta<E> toDelta(difflib.Delta<E> delta) throws DiffException {
        AbstractDelta newDelta;
        switch (delta.getType()) {
            case CHANGE: {
                newDelta = new ChangeDelta(delta.getOriginal(), delta.getRevised());
                break;
            }
            case DELETE: {
                newDelta = new DeleteDelta(delta.getOriginal(), delta.getRevised());
                break;
            }
            case INSERT: {
                newDelta = new InsertDelta(delta.getOriginal(), delta.getRevised());
                break;
            }
            default: {
                throw new DiffException(String.format("Failed to convert [%s] info [%s]. Unknown type [%s]", delta.getClass().getName(), Delta.class.getName(), delta.getType().toString()));
            }
        }
        return newDelta;
    }

    @Override
    public List<E> apply(List<E> target) throws PatchException {
        LinkedList<E> result = new LinkedList<E>(target);
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            Delta delta = (Delta)it.previous();
            delta.apply(result);
        }
        return result;
    }

    @Override
    public List<E> restore(List<E> target) throws PatchException {
        LinkedList<E> result = new LinkedList<E>(target);
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            Delta delta = (Delta)it.previous();
            delta.restore(result);
        }
        return result;
    }
}

