/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.environment.internal;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.environment.Environment;
import org.xwiki.environment.EnvironmentConfiguration;

public abstract class AbstractEnvironment
implements Environment {
    private static final File DEFAULT_TMP_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    @Inject
    protected Logger logger;
    @Inject
    private Provider<EnvironmentConfiguration> configurationProvider;
    private File temporaryDirectory;
    private File permanentDirectory;

    public void setPermanentDirectory(File permanentDirectory) {
        this.permanentDirectory = permanentDirectory;
    }

    public void setTemporaryDirectory(File temporaryDirectory) {
        this.temporaryDirectory = temporaryDirectory;
    }

    public File getPermanentDirectory() {
        if (this.permanentDirectory == null) {
            this.permanentDirectory = ((EnvironmentConfiguration)this.configurationProvider.get()).getPermanentDirectory();
            if (this.permanentDirectory == null) {
                this.permanentDirectory = this.getTemporaryDirectory();
                this.logger.warn("No permanent directory configured. Using a temporary directory [{}]", (Object)this.permanentDirectory);
            }
        }
        return this.permanentDirectory;
    }

    public File getTemporaryDirectory() {
        File tmpDirectory = this.getTemporaryDirectoryInternal() == null ? DEFAULT_TMP_DIRECTORY : this.getTemporaryDirectoryInternal();
        return tmpDirectory;
    }

    protected File getTemporaryDirectoryInternal() {
        return this.temporaryDirectory;
    }
}

