/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.configuration.internal.MemoryConfigurationSource;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlan;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.job.Job;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.test.annotation.AfterComponent;
import org.xwiki.test.annotation.AllComponents;
import org.xwiki.test.junit5.mockito.InjectComponentManager;
import org.xwiki.test.mockito.MockitoComponentManager;

@AllComponents
public abstract class AbstractExtensionHandlerTest {
    @InjectComponentManager
    protected MockitoComponentManager componentManager;
    protected LocalExtensionRepository localExtensionRepository;
    protected InstalledExtensionRepository installedExtensionRepository;
    protected JobExecutor jobExecutor;
    protected MemoryConfigurationSource memoryConfigurationSource;

    @AfterComponent
    public void afterComponent() throws Exception {
        if (!this.componentManager.hasComponent(CacheFactory.class, "infinispan")) {
            CacheFactory infinispan = (CacheFactory)this.componentManager.registerMockComponent(CacheFactory.class, "infinispan");
            Mockito.when((Object)infinispan.newCache((CacheConfiguration)ArgumentMatchers.any())).thenReturn(Mockito.mock(Cache.class));
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.jobExecutor = (JobExecutor)this.componentManager.getInstance(JobExecutor.class);
        this.localExtensionRepository = (LocalExtensionRepository)this.componentManager.getInstance(LocalExtensionRepository.class);
        this.installedExtensionRepository = (InstalledExtensionRepository)this.componentManager.getInstance(InstalledExtensionRepository.class);
        this.componentManager.registerMockComponent(CacheManager.class);
        this.memoryConfigurationSource = this.componentManager.registerMemoryConfigurationSource();
    }

    protected ExtensionPlanNode getNode(ExtensionId id, Collection<ExtensionPlanNode> nodes) {
        for (ExtensionPlanNode node : nodes) {
            if (!node.getAction().getExtension().getId().equals((Object)id)) continue;
            return node;
        }
        return null;
    }

    protected Job executeJob(String jobId, Request request, LogLevel failFrom) throws Throwable {
        Job installJob = this.jobExecutor.execute(jobId, request);
        installJob.join();
        if (installJob.getStatus().getError() != null) {
            throw installJob.getStatus().getError();
        }
        Optional errorResult = installJob.getStatus().getLogTail().getLogEvents(failFrom).stream().findFirst();
        if (errorResult.isPresent()) {
            LogEvent error = (LogEvent)errorResult.get();
            throw error.getThrowable() != null ? error.getThrowable() : new Exception(error.getFormattedMessage());
        }
        return installJob;
    }

    protected InstalledExtension install(ExtensionId extensionId) throws Throwable {
        return this.install(extensionId, true);
    }

    protected InstalledExtension install(ExtensionId extensionId, boolean rootModifications) throws Throwable {
        return this.install(extensionId, (String[])null, rootModifications);
    }

    protected InstalledExtension install(ExtensionId extensionId, String[] namespaces) throws Throwable {
        return this.install(extensionId, namespaces, true);
    }

    protected InstalledExtension install(ExtensionId extensionId, String[] namespaces, boolean rootModifications) throws Throwable {
        return this.install(extensionId, namespaces, rootModifications, LogLevel.WARN);
    }

    protected InstalledExtension install(ExtensionId extensionId, String namespace) throws Throwable {
        return this.install(extensionId, namespace, true);
    }

    protected InstalledExtension install(ExtensionId extensionId, String namespace, boolean rootModifications) throws Throwable {
        return this.install(extensionId, namespace, rootModifications, LogLevel.WARN);
    }

    protected InstalledExtension install(ExtensionId extensionId, String namespace, LogLevel failFrom) throws Throwable {
        return this.install(extensionId, namespace, true, failFrom);
    }

    protected InstalledExtension install(ExtensionId extensionId, String namespace, boolean rootModifications, LogLevel failFrom) throws Throwable {
        String[] stringArray;
        if (namespace != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = namespace;
        } else {
            stringArray = null;
        }
        return this.install(extensionId, stringArray, rootModifications, failFrom);
    }

    protected InstalledExtension install(ExtensionId extensionId, String[] namespaces, LogLevel failFrom) throws Throwable {
        return this.install(extensionId, namespaces, true, failFrom);
    }

    protected InstalledExtension install(ExtensionId extensionId, String[] namespaces, boolean rootModifications, LogLevel failFrom) throws Throwable {
        this.install("install", extensionId, namespaces, rootModifications, failFrom);
        return this.installedExtensionRepository.resolve(extensionId);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId) throws Throwable {
        return this.installPlan(extensionId, true);
    }

    protected ExtensionPlan installPlan(Collection<ExtensionId> extensionIds) throws Throwable {
        return this.installPlan(extensionIds, true);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, boolean rootModifications) throws Throwable {
        return this.installPlan(extensionId, (String[])null, rootModifications);
    }

    protected ExtensionPlan installPlan(Collection<ExtensionId> extensionIds, boolean rootModifications) throws Throwable {
        return this.installPlan(extensionIds, (String[])null, rootModifications);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String[] namespaces) throws Throwable {
        return this.installPlan(extensionId, namespaces, true);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String[] namespaces, boolean rootModifications) throws Throwable {
        return this.installPlan(extensionId, namespaces, rootModifications, LogLevel.WARN);
    }

    protected ExtensionPlan installPlan(Collection<ExtensionId> extensionIds, String[] namespaces, boolean rootModifications) throws Throwable {
        return this.installPlan(extensionIds, namespaces, rootModifications, LogLevel.WARN);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String namespace) throws Throwable {
        return this.installPlan(extensionId, namespace, true);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String namespace, boolean rootModifications) throws Throwable {
        String[] stringArray;
        if (namespace != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = namespace;
        } else {
            stringArray = null;
        }
        return this.installPlan(extensionId, stringArray, rootModifications, LogLevel.WARN);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String[] namespaces, LogLevel failFrom) throws Throwable {
        return this.installPlan(extensionId, namespaces, true, failFrom);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String[] namespaces, boolean rootModifications, LogLevel failFrom) throws Throwable {
        return this.installPlan(Arrays.asList(extensionId), namespaces, rootModifications, failFrom);
    }

    protected ExtensionPlan installPlan(Collection<ExtensionId> extensionIds, String[] namespaces, boolean rootModifications, LogLevel failFrom) throws Throwable {
        InstallRequest installRequest = this.createInstallRequest(extensionIds, namespaces, rootModifications);
        return this.installPlan(installRequest, failFrom);
    }

    protected ExtensionPlan installPlan(InstallRequest installRequest) throws Throwable {
        return this.installPlan(installRequest, LogLevel.WARN);
    }

    protected ExtensionPlan installPlan(InstallRequest installRequest, LogLevel failFrom) throws Throwable {
        Job installJob = this.executeJob("installplan", (Request)installRequest, failFrom);
        return (ExtensionPlan)installJob.getStatus();
    }

    protected Job install(String jobId, ExtensionId extensionId, String[] namespaces, LogLevel failFrom) throws Throwable {
        return this.install(jobId, extensionId, namespaces, true, failFrom);
    }

    protected Job install(String jobId, ExtensionId extensionId, String[] namespaces, boolean rootModifications, LogLevel failFrom) throws Throwable {
        InstallRequest installRequest = this.createInstallRequest(extensionId, namespaces, rootModifications);
        return this.executeJob(jobId, (Request)installRequest, failFrom);
    }

    protected InstallRequest createInstallRequest(ExtensionId extensionId) {
        return this.createInstallRequest(extensionId, null, true);
    }

    protected InstallRequest createInstallRequest(ExtensionId extensionId, String[] namespaces, boolean rootModifications) {
        return this.createInstallRequest(Arrays.asList(extensionId), namespaces, rootModifications);
    }

    protected InstallRequest createInstallRequest(Collection<ExtensionId> extensionIds) {
        return this.createInstallRequest(extensionIds);
    }

    protected InstallRequest createInstallRequest(Collection<ExtensionId> extensionIds, String[] namespaces, boolean rootModifications) {
        InstallRequest installRequest = new InstallRequest();
        extensionIds.stream().forEach(id -> installRequest.addExtension(id));
        if (namespaces != null) {
            for (String namespace : namespaces) {
                installRequest.addNamespace(namespace);
            }
        }
        installRequest.setRootModificationsAllowed(rootModifications);
        installRequest.setVerbose(false);
        return installRequest;
    }

    protected LocalExtension uninstall(ExtensionId extensionId) throws Throwable {
        return this.uninstall(extensionId, (Iterable<String>)null);
    }

    protected LocalExtension uninstall(ExtensionId extensionId, String namespace) throws Throwable {
        return this.uninstall(extensionId, namespace, LogLevel.WARN);
    }

    protected LocalExtension uninstall(ExtensionId extensionId, Iterable<String> namespaces) throws Throwable {
        return this.uninstall(extensionId, namespaces, LogLevel.WARN);
    }

    protected LocalExtension uninstall(ExtensionId extensionId, LogLevel failFrom) throws Throwable {
        return this.uninstall(extensionId, (Iterable<String>)null, failFrom);
    }

    protected LocalExtension uninstall(ExtensionId extensionId, String namespace, LogLevel failFrom) throws Throwable {
        return this.uninstall(extensionId, namespace != null ? Arrays.asList(namespace) : null, failFrom);
    }

    protected LocalExtension uninstall(ExtensionId extensionId, Iterable<String> namespaces, LogLevel failFrom) throws Throwable {
        this.uninstall("uninstall", extensionId, namespaces, failFrom);
        return this.localExtensionRepository.resolve(extensionId);
    }

    protected DefaultExtensionPlan<UninstallRequest> uninstallPlan(ExtensionId extensionId, String namespace, LogLevel failFrom) throws Throwable {
        Job uninstallJob = this.uninstall("installplan", extensionId, namespace, failFrom);
        return (DefaultExtensionPlan)uninstallJob.getStatus();
    }

    protected Job uninstall(String jobId, ExtensionId extensionId, String namespace, LogLevel failFrom) throws Throwable {
        return this.uninstall(jobId, extensionId, namespace != null ? Arrays.asList(namespace) : null, failFrom);
    }

    protected Job uninstall(String jobId, ExtensionId extensionId, Iterable<String> namespaces, LogLevel failFrom) throws Throwable {
        UninstallRequest uninstallRequest = new UninstallRequest();
        uninstallRequest.addExtension(extensionId);
        if (namespaces != null) {
            namespaces.forEach(arg_0 -> ((UninstallRequest)uninstallRequest).addNamespace(arg_0));
        }
        return this.executeJob(jobId, (Request)uninstallRequest, failFrom);
    }

    protected ExtensionPlan upgradePlan() throws Throwable {
        return this.upgradePlan((String)null);
    }

    protected ExtensionPlan upgradePlan(String namespace) throws Throwable {
        return this.upgradePlan(namespace, (Collection<ExtensionId>)null);
    }

    protected ExtensionPlan upgradePlan(String namespace, Collection<ExtensionId> excludedExtensions) throws Throwable {
        return this.upgradePlan(namespace, excludedExtensions, LogLevel.WARN);
    }

    protected ExtensionPlan upgradePlan(String namespace, LogLevel failFrom) throws Throwable {
        return this.upgradePlan(namespace, null, failFrom);
    }

    protected ExtensionPlan upgradePlan(String namespace, Collection<ExtensionId> excludedExtensions, LogLevel failFrom) throws Throwable {
        InstallRequest installRequest = new InstallRequest();
        if (namespace != null) {
            installRequest.addNamespace(namespace);
        }
        if (excludedExtensions != null) {
            installRequest.getExcludedExtensions().addAll(excludedExtensions);
        }
        return (ExtensionPlan)this.executeJob("upgradeplan", (Request)installRequest, failFrom).getStatus();
    }

    protected ExtensionPlan upgradePlan(InstallRequest installRequest) throws Throwable {
        return this.upgradePlan(installRequest, LogLevel.WARN);
    }

    protected ExtensionPlan upgradePlan(InstallRequest installRequest, LogLevel failFrom) throws Throwable {
        return (ExtensionPlan)this.executeJob("upgradeplan", (Request)installRequest, failFrom).getStatus();
    }
}

