/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.test.AbstractRepositorySerializer;

public class MavenRepositorySerializer
extends AbstractRepositorySerializer {
    public static final String DEFAULT_GROUPID = "maven";

    public MavenRepositorySerializer(File root) {
        super(root);
    }

    @Override
    public String resolveId(String id) {
        int index = id.indexOf(58);
        if (index > 0) {
            return id;
        }
        return "maven:" + id;
    }

    @Override
    public File getFile(String id, String version, String type) {
        String artifactId;
        String groupId;
        int index = id.indexOf(58);
        if (index > 0) {
            groupId = id.substring(0, index);
            artifactId = id.substring(index + 1);
        } else {
            groupId = DEFAULT_GROUPID;
            artifactId = id;
        }
        File path = this.root;
        for (String element : StringUtils.split((String)groupId, (char)'.')) {
            path = new File(path, element);
        }
        path = new File(path, artifactId);
        path = new File(path, version);
        path = new File(path, artifactId + '-' + version + '.' + type);
        return path;
    }
}

