/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.MemoryConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.test.ConfigurableDefaultCoreExtensionRepository;
import org.xwiki.extension.test.FileExtensionRepository;
import org.xwiki.extension.test.RepositoryUtils;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.test.mockito.MockitoComponentManager;

public class MockitoRepositoryUtils
extends RepositoryUtils {
    protected final MockitoComponentManager componentManager;
    private FileExtensionRepository remoteRepository;
    private ComponentAnnotationLoader componentLoader;

    public MockitoRepositoryUtils(MockitoComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @Override
    public void setup() throws Exception {
        Environment environment = null;
        if (this.componentManager.hasComponent(Environment.class)) {
            environment = (Environment)this.componentManager.getInstance(Environment.class);
            if (MockUtil.isMock((Object)environment)) {
                this.initializeDirectories(environment);
            } else {
                environment = null;
            }
        }
        if (environment == null) {
            environment = (Environment)this.componentManager.registerMockComponent(Environment.class);
            Mockito.when((Object)environment.getPermanentDirectory()).thenReturn((Object)this.getPermanentDirectory());
            Mockito.when((Object)environment.getTemporaryDirectory()).thenReturn((Object)this.getTemporaryDirectory());
            Mockito.when((Object)environment.getResourceAsStream((String)ArgumentMatchers.any())).thenReturn(null);
        }
        super.setup();
        Object configurationSource = !this.componentManager.hasComponent(ConfigurationSource.class) ? this.componentManager.registerMemoryConfigurationSource() : (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class);
        if (configurationSource instanceof MemoryConfigurationSource) {
            configurationSource.setProperty("extension.repositories", Arrays.asList(""));
        }
        this.registerComponent(ConfigurableDefaultCoreExtensionRepository.class);
        ((ConfigurableDefaultCoreExtensionRepository)((Object)this.componentManager.getInstance(CoreExtensionRepository.class))).addExtensions("coreextension", (Version)new DefaultVersion("version"), new ExtensionId[0]);
        ExtensionRepositoryManager repositoryManager = (ExtensionRepositoryManager)this.componentManager.getInstance(ExtensionRepositoryManager.class);
        if (this.copyResourceFolder(this.getRemoteRepository(), "repository.remote") > 0) {
            this.remoteRepository = new FileExtensionRepository(this.getRemoteRepository(), (ComponentManager)this.componentManager);
            repositoryManager.addRepository((ExtensionRepository)this.remoteRepository);
        }
        if (this.getMavenRepository().exists()) {
            repositoryManager.addRepository((ExtensionRepositoryDescriptor)this.newLocalMavenRepository("test-maven", this.getMavenRepository().toURI()));
        }
        if (this.getMaven2Repository().exists()) {
            repositoryManager.addRepository((ExtensionRepositoryDescriptor)this.newLocalMavenRepository("test-maven2", this.getMaven2Repository().toURI()));
        }
        this.componentManager.getInstance(ExtensionInitializer.class);
    }

    private DefaultExtensionRepositoryDescriptor newLocalMavenRepository(String id, URI uri) {
        DefaultExtensionRepositoryDescriptor descriptor = new DefaultExtensionRepositoryDescriptor(id, "maven", uri);
        descriptor.putProperty("checksumPolicy", "ignore");
        return descriptor;
    }

    public MockitoComponentManager getComponentManager() {
        return this.componentManager;
    }

    public ComponentAnnotationLoader getComponentLoader() {
        if (this.componentLoader == null) {
            this.componentLoader = new ComponentAnnotationLoader();
        }
        return this.componentLoader;
    }

    private void registerComponent(Class<?> componentClass) throws Exception {
        List descriptors = this.getComponentLoader().getComponentsDescriptors(componentClass);
        for (ComponentDescriptor descriptor : descriptors) {
            this.componentManager.registerComponent(descriptor);
        }
    }
}

