/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionPattern;
import org.xwiki.extension.internal.ExtensionUtils;

public class ExtensionPlanContext {
    private final Map<String, ExtensionDependency> managedDependencies;
    private final List<ExtensionPattern> excludes;

    public ExtensionPlanContext() {
        this.managedDependencies = Collections.emptyMap();
        this.excludes = Collections.emptyList();
    }

    public ExtensionPlanContext(ExtensionPlanContext extensionContext, Extension rewrittenExtension) {
        this.managedDependencies = ExtensionUtils.append(extensionContext.managedDependencies, rewrittenExtension);
        this.excludes = extensionContext.excludes;
    }

    public ExtensionPlanContext(ExtensionPlanContext extensionContext, ExtensionDependency dependency) {
        this.managedDependencies = extensionContext.managedDependencies;
        this.excludes = ExtensionUtils.appendExclusions(extensionContext.excludes, dependency);
    }

    public ExtensionDependency getDependency(ExtensionDependency dependency, Extension extension) {
        ExtensionDependency managedDependency = this.managedDependencies.get(dependency.getId());
        if (managedDependency == null && dependency.getVersionConstraint() == null) {
            for (ExtensionDependency extensionManagedDependency : extension.getManagedDependencies()) {
                if (!extensionManagedDependency.getId().equals(dependency.getId())) continue;
                managedDependency = extensionManagedDependency;
            }
        }
        if (managedDependency != null) {
            return new DefaultExtensionDependency(dependency, managedDependency.getVersionConstraint());
        }
        return dependency;
    }

    public boolean isExcluded(ExtensionDependency dependency) {
        for (ExtensionPattern pattern : this.excludes) {
            if (!pattern.matches(dependency)) continue;
            return true;
        }
        return false;
    }
}

