/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.plan.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.version.VersionConstraint;

public class DefaultExtensionPlanNode
implements ExtensionPlanNode,
Cloneable {
    protected ExtensionPlanAction action;
    protected Collection<ExtensionPlanNode> children;
    protected VersionConstraint initialVersionConstraint;

    public DefaultExtensionPlanNode() {
    }

    public DefaultExtensionPlanNode(ExtensionPlanNode node) {
        this(node.getAction(), node.getChildren(), node.getInitialVersionConstraint());
    }

    public DefaultExtensionPlanNode(ExtensionPlanAction action, VersionConstraint initialVersionConstraint) {
        this(action, null, initialVersionConstraint);
    }

    public DefaultExtensionPlanNode(ExtensionPlanAction action, Collection<ExtensionPlanNode> children, VersionConstraint initialVersionConstraint) {
        this.action = action;
        this.children = children != null ? new CopyOnWriteArrayList<ExtensionPlanNode>(children) : Collections.emptyList();
        this.initialVersionConstraint = initialVersionConstraint;
    }

    protected DefaultExtensionPlanNode clone() {
        try {
            return (DefaultExtensionPlanNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public ExtensionPlanAction getAction() {
        return this.action;
    }

    @Override
    public Collection<ExtensionPlanNode> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    @Override
    public VersionConstraint getInitialVersionConstraint() {
        return this.initialVersionConstraint;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAction());
        builder.append(" (");
        builder.append(this.getChildren());
        if (this.getInitialVersionConstraint() != null) {
            builder.append(", ");
            builder.append(this.getInitialVersionConstraint());
        }
        builder.append(')');
        return builder.toString();
    }
}

