/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.extension.internal.PathUtils;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;

@Component(roles={CoreExtensionCache.class})
@Singleton
public class CoreExtensionCache
implements Initializable {
    private static final String PACKAGE_MARKER = "!/";
    @Inject
    private Environment environment;
    @Inject
    private ExtensionSerializer serializer;
    @Inject
    private Logger logger;
    private File folder;

    public void initialize() throws InitializationException {
        File permanentDirectory = this.environment.getPermanentDirectory();
        if (permanentDirectory != null) {
            this.folder = new File(permanentDirectory, "cache/extension/core/");
        }
    }

    public void store(DefaultCoreExtension extension) throws Exception {
        if (this.folder == null) {
            return;
        }
        URL descriptorURL = extension.getDescriptorURL();
        if (!descriptorURL.getPath().contains(PACKAGE_MARKER)) {
            return;
        }
        File file = this.getFile(descriptorURL);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            this.serializer.saveExtensionDescriptor(extension, stream);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultCoreExtension getExtension(DefaultCoreExtensionRepository repository, URL descriptorURL) {
        if (this.folder == null) {
            return null;
        }
        if (!descriptorURL.getPath().contains(PACKAGE_MARKER)) {
            return null;
        }
        File file = this.getFile(descriptorURL);
        if (!file.exists()) return null;
        try (FileInputStream stream = new FileInputStream(file);){
            DefaultCoreExtension defaultCoreExtension = this.serializer.loadCoreExtensionDescriptor(repository, descriptorURL, stream);
            return defaultCoreExtension;
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse cached core extension descriptor [{}]", (Object)descriptorURL, (Object)e);
        }
        return null;
    }

    private String getExtensionFileName(URL url) {
        URL extensionURL;
        try {
            extensionURL = PathUtils.getExtensionURL(url);
        }
        catch (IOException e) {
            return null;
        }
        String extensionPath = extensionURL.toExternalForm();
        int index = extensionPath.lastIndexOf(47);
        if (index > 0 && index < extensionPath.length()) {
            if ((index = (extensionPath = extensionPath.substring(index + 1)).lastIndexOf(46)) > 0 && index < extensionPath.length()) {
                extensionPath = extensionPath.substring(0, index);
            }
            return extensionPath;
        }
        return null;
    }

    private File getFile(URL url) {
        StringBuilder builder = new StringBuilder();
        String fileName = this.getExtensionFileName(url);
        if (fileName != null) {
            builder.append(fileName);
            builder.append('-');
        }
        builder.append(DigestUtils.md5Hex((String)url.toExternalForm()));
        builder.append(".xed");
        return new File(this.folder, builder.toString());
    }
}

