/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.version.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.version.InvalidVersionRangeException;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.VersionUtils;

public class DefaultVersionRange
implements VersionRange {
    private static final long serialVersionUID = 1L;
    private static final char RANGE_SEPARATOR = ',';
    private Version lowerBound;
    private boolean lowerBoundInclusive;
    private Version upperBound;
    private boolean upperBoundInclusive;
    private String value;

    public DefaultVersionRange(String rawRange) throws InvalidVersionRangeException {
        this.setRange(rawRange);
    }

    public DefaultVersionRange(Version lowerBound, boolean lowerBoundInclusive, Version upperBound, boolean upperBoundInclusive) {
        this.lowerBound = lowerBound;
        this.lowerBoundInclusive = lowerBoundInclusive;
        this.upperBound = upperBound;
        this.upperBoundInclusive = upperBoundInclusive;
    }

    private void setRange(String rawRange) throws InvalidVersionRangeException {
        String range = this.value = rawRange;
        this.lowerBoundInclusive = this.findLowerBoundInclusive(range);
        this.upperBoundInclusive = this.findUpperBoundInclusive(range);
        int index = (range = range.substring(1, range.length() - 1)).indexOf(44);
        if (index < 0) {
            if (!this.lowerBoundInclusive || !this.upperBoundInclusive) {
                throw new InvalidVersionRangeException(MessageFormat.format("Invalid version range [{0}], single version must be surrounded by []", rawRange));
            }
            this.lowerBound = this.upperBound = new DefaultVersion(range.trim());
        } else {
            String parsedLowerBound = range.substring(0, index).trim();
            String parsedUpperBound = range.substring(index + 1).trim();
            if (StringUtils.contains((CharSequence)parsedUpperBound, (int)44)) {
                throw new InvalidVersionRangeException(MessageFormat.format("Invalid version range [{0}], bounds may not contain additional ','", rawRange));
            }
            this.lowerBound = parsedLowerBound.length() > 0 ? new DefaultVersion(parsedLowerBound) : null;
            Version version = this.upperBound = parsedUpperBound.length() > 0 ? new DefaultVersion(parsedUpperBound) : null;
            if (this.upperBound != null && this.lowerBound != null && this.upperBound.compareTo(this.lowerBound) < 0) {
                throw new InvalidVersionRangeException(MessageFormat.format("Invalid version range [{0}], lower bound must not be greater than upper bound", rawRange));
            }
        }
    }

    private boolean findLowerBoundInclusive(String range) throws InvalidVersionRangeException {
        if (VersionUtils.startsWith(range, '[')) {
            return true;
        }
        if (VersionUtils.startsWith(range, '(')) {
            return false;
        }
        throw new InvalidVersionRangeException(MessageFormat.format("Invalid version range [{0}], a range must start with either [ or (", range));
    }

    private boolean findUpperBoundInclusive(String range) throws InvalidVersionRangeException {
        if (VersionUtils.endsWith(range, ']')) {
            return true;
        }
        if (VersionUtils.endsWith(range, ')')) {
            return false;
        }
        throw new InvalidVersionRangeException(MessageFormat.format("Invalid version range [{0}], a range must end with either [ or (", range));
    }

    @Override
    public boolean containsVersion(Version version) {
        if (version instanceof DefaultVersion) {
            return this.containsVersion((DefaultVersion)version);
        }
        return this.containsVersion(new DefaultVersion(version.getValue()));
    }

    public boolean containsVersion(DefaultVersion version) {
        int comparison;
        if (this.lowerBound != null) {
            comparison = this.lowerBound.compareTo(version);
            if (comparison == 0 && !this.lowerBoundInclusive) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.compareTo(version);
            if (comparison == 0 && !this.upperBoundInclusive) {
                return false;
            }
            if (comparison < 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.lowerBoundInclusive ? (char)'[' : '(');
            if (this.lowerBound != null) {
                buffer.append(this.lowerBound);
            }
            buffer.append(',');
            if (this.upperBound != null) {
                buffer.append(this.upperBound);
            }
            buffer.append(this.upperBoundInclusive ? (char)']' : ')');
            this.value = buffer.toString();
        }
        return this.value;
    }

    @Override
    public boolean isCompatible(VersionRange otherRange) {
        boolean compatible;
        if (this.equals(otherRange)) {
            compatible = true;
        } else if (otherRange instanceof DefaultVersionRange) {
            compatible = this.isCompatible((DefaultVersionRange)otherRange);
        } else {
            try {
                compatible = this.isCompatible(new DefaultVersionRange(otherRange.getValue()));
            }
            catch (InvalidVersionRangeException e) {
                compatible = false;
            }
        }
        return compatible;
    }

    public boolean isCompatible(DefaultVersionRange otherRange) {
        int lowerCompare = this.compareTo(this.lowerBound, this.lowerBoundInclusive, otherRange.lowerBound, otherRange.lowerBoundInclusive, false);
        int upperCompare = this.compareTo(this.upperBound, this.upperBoundInclusive, otherRange.upperBound, otherRange.upperBoundInclusive, true);
        if (lowerCompare == 0 || upperCompare == 0) {
            return true;
        }
        if (lowerCompare > 0 && upperCompare < 0) {
            return true;
        }
        if (lowerCompare < 0 && upperCompare > 0) {
            return true;
        }
        return lowerCompare < 0 ? this.isCompatible(this.upperBound, this.upperBoundInclusive, otherRange.lowerBound, otherRange.lowerBoundInclusive) : this.isCompatible(otherRange.upperBound, otherRange.upperBoundInclusive, this.lowerBound, this.lowerBoundInclusive);
    }

    private int compareTo(Version version1, boolean included1, Version version2, boolean included2, boolean upper) {
        int compare = version1 == null ? (version2 == null ? 0 : (upper ? 1 : -1)) : (version2 == null ? (upper ? -1 : 1) : this.compareNotNull(version1, included1, version2, included2, upper));
        return compare;
    }

    private int compareNotNull(Version version1, boolean included1, Version version2, boolean included2, boolean upper) {
        int compare = version1.compareTo(version2);
        if (compare == 0 && included1 != included2) {
            compare = included1 ? (upper ? -1 : 1) : (upper ? 1 : -1);
        }
        return compare;
    }

    private boolean isCompatible(Version upper, boolean upperInclusive, Version lower, boolean lowerInclusive) {
        boolean compatible = true;
        if (upper != null && lower != null) {
            int comparison = upper.compareTo(lower);
            compatible = comparison > 0 ? true : (comparison < 0 ? false : upperInclusive && lowerInclusive);
        }
        return compatible;
    }

    public String toString() {
        return this.getValue();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 31);
        builder.append((Object)this.upperBound);
        builder.append(this.upperBoundInclusive ? 1 : 0);
        builder.append((Object)this.lowerBound);
        builder.append(this.lowerBoundInclusive ? 1 : 0);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultVersionRange) {
            equals = this.equals((DefaultVersionRange)obj);
        } else if (obj instanceof VersionRange) {
            try {
                equals = this.equals(new DefaultVersionRange(((VersionRange)obj).getValue()));
            }
            catch (InvalidVersionRangeException e) {
                equals = false;
            }
        } else {
            equals = false;
        }
        return equals;
    }

    public boolean equals(DefaultVersionRange version) {
        return this.upperBoundInclusive == version.upperBoundInclusive && this.lowerBoundInclusive == version.lowerBoundInclusive && ObjectUtils.equals((Object)this.upperBound, (Object)version.upperBound) && ObjectUtils.equals((Object)this.lowerBound, (Object)version.lowerBound);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getValue());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, InvalidVersionRangeException {
        this.setRange((String)in.readObject());
    }
}

