/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension.internal.safe;

import org.xwiki.component.annotation.Role;

/**
 * Provide a wrapped (or not) version of the passed object so that it's safe to use in a public script.
 * 
 * @param <T>
 * @version $Id: 8740cc2bffaddd462a74bb43a750b558fbb82381 $
 * @since 4.0M2
 */
@Role
public interface ScriptSafeProvider<T>
{
    /**
     * @param <S> the type of the safe object version
     * @param unsafe the unsafe version of the object
     * @return a safe version of the passed object
     */
    <S> S get(T unsafe);
}
