/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import javax.inject.Inject;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.job.internal.AbstractJob;
import org.xwiki.job.internal.AbstractJobStatus;
import org.xwiki.observation.event.Event;

public abstract class AbstractExtensionJob<R extends ExtensionRequest, S extends AbstractJobStatus<R>>
extends AbstractJob<R, S> {
    public static final String CONTEXTKEY_PLAN = "job.extension.plan";
    @Inject
    protected LocalExtensionRepository localExtensionRepository;
    @Inject
    protected ExtensionHandlerManager extensionHandlerManager;
    @Inject
    protected InstalledExtensionRepository installedExtensionRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyActions(Collection<ExtensionPlanAction> actions) throws InstallException, UninstallException, ResolveException {
        this.notifyPushLevelProgress(actions.size());
        try {
            for (ExtensionPlanAction action : actions) {
                if (action.getAction() != ExtensionPlanAction.Action.NONE) {
                    this.applyAction(action);
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyAction(ExtensionPlanAction action) throws InstallException, UninstallException, ResolveException {
        Extension extension = action.getExtension();
        String namespace = action.getNamespace();
        if (namespace != null) {
            this.logger.info("Applying {} for extension [{}] on namespace [{}]", new Object[]{action.getAction(), extension.getId(), namespace});
        } else {
            this.logger.info("Applying {} for extension [{}] on all namespaces", (Object)action.getAction(), (Object)extension.getId());
        }
        this.notifyPushLevelProgress(2);
        try {
            if (action.getAction() == ExtensionPlanAction.Action.UNINSTALL) {
                InstalledExtension installedExtension = (InstalledExtension)action.getExtension();
                this.notifyStepPropress();
                this.uninstallExtension(installedExtension, namespace);
            } else {
                LocalExtension localExtension = this.localExtensionRepository.resolve(extension.getId());
                this.notifyStepPropress();
                this.installExtension(localExtension, action.getPreviousExtension(), namespace, action.isDependency());
            }
            if (namespace != null) {
                this.logger.info("Successfully applied {} for extension [{}] on namespace [{}]", new Object[]{action.getAction(), extension.getId(), namespace});
            } else {
                this.logger.info("Successfully applied {} for extension [{}] on all namespaces", (Object)action.getAction(), (Object)extension.getId());
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    private void uninstallExtension(InstalledExtension installedExtension, String namespace) throws UninstallException {
        this.extensionHandlerManager.uninstall(installedExtension, namespace, this.getRequest());
        this.installedExtensionRepository.uninstallExtension(installedExtension, namespace);
        this.observationManager.notify((Event)new ExtensionUninstalledEvent(installedExtension.getId(), namespace), (Object)installedExtension);
    }

    private void installExtension(LocalExtension extension, InstalledExtension previousExtension, String namespace, boolean dependency) throws InstallException {
        if (previousExtension == null) {
            this.extensionHandlerManager.install(extension, namespace, this.getRequest());
            InstalledExtension installedExtension = this.installedExtensionRepository.installExtension(extension, namespace, dependency);
            this.observationManager.notify((Event)new ExtensionInstalledEvent(extension.getId(), namespace), (Object)installedExtension);
        } else {
            this.extensionHandlerManager.upgrade(previousExtension, extension, namespace, this.getRequest());
            try {
                this.installedExtensionRepository.uninstallExtension(previousExtension, namespace);
            }
            catch (UninstallException e) {
                this.logger.error("Failed to uninstall extension [" + previousExtension.getId() + "]", (Throwable)e);
            }
            InstalledExtension installedExtension = this.installedExtensionRepository.installExtension(extension, namespace, dependency);
            this.observationManager.notify((Event)new ExtensionUpgradedEvent(extension.getId(), namespace), (Object)installedExtension, (Object)previousExtension);
        }
    }
}

