/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.ExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.ExtensionRepositorySource;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.result.AggregatedIterableResult;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;
import org.xwiki.extension.version.Version;

@Component
@Singleton
public class DefaultExtensionRepositoryManager
implements ExtensionRepositoryManager,
Initializable {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    private List<ExtensionRepositorySource> repositoriesSources;
    private Map<String, ExtensionRepository> repositories = new ConcurrentHashMap<String, ExtensionRepository>();

    public void initialize() throws InitializationException {
        for (ExtensionRepositorySource repositoriesSource : this.repositoriesSources) {
            for (ExtensionRepositoryDescriptor repositoryDescriptor : repositoriesSource.getExtensionRepositoryDescriptors()) {
                try {
                    this.addRepository(repositoryDescriptor);
                }
                catch (ExtensionRepositoryException e) {
                    this.logger.error("Failed to add repository [" + repositoryDescriptor + "]", (Throwable)e);
                }
            }
        }
    }

    @Override
    @Deprecated
    public ExtensionRepository addRepository(ExtensionRepositoryId repositoryId) throws ExtensionRepositoryException {
        return this.addRepository((ExtensionRepositoryDescriptor)repositoryId);
    }

    @Override
    public ExtensionRepository addRepository(ExtensionRepositoryDescriptor repositoryDescriptor) throws ExtensionRepositoryException {
        ExtensionRepository repository;
        try {
            ExtensionRepositoryFactory repositoryFactory = (ExtensionRepositoryFactory)this.componentManager.getInstance(ExtensionRepositoryFactory.class, repositoryDescriptor.getType());
            repository = repositoryFactory.createRepository(repositoryDescriptor);
            this.addRepository(repository);
        }
        catch (ComponentLookupException e) {
            throw new ExtensionRepositoryException("Unsupported repository type [" + repositoryDescriptor.getType() + "]", e);
        }
        return repository;
    }

    @Override
    public void addRepository(ExtensionRepository repository) {
        this.repositories.put(repository.getDescriptor().getId(), repository);
    }

    @Override
    public void removeRepository(String repositoryId) {
        this.repositories.remove(repositoryId);
    }

    @Override
    public ExtensionRepository getRepository(String repositoryId) {
        return this.repositories.get(repositoryId);
    }

    @Override
    public Collection<ExtensionRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories.values());
    }

    @Override
    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        ResolveException lastExtension = null;
        for (ExtensionRepository repository : this.repositories.values()) {
            try {
                return repository.resolve(extensionId);
            }
            catch (ResolveException e) {
                this.logger.debug("Could not find extension [{}] in repository [{}]", new Object[]{extensionId, repository.getDescriptor(), e});
                lastExtension = e;
            }
        }
        throw new ResolveException(MessageFormat.format("Could not find extension [{0}]", extensionId), lastExtension);
    }

    @Override
    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        ResolveException lastExtension = null;
        for (ExtensionRepository repository : this.repositories.values()) {
            try {
                return repository.resolve(extensionDependency);
            }
            catch (ResolveException e) {
                this.logger.debug("Could not find extension dependency [{}] in repository [{}]", new Object[]{extensionDependency, repository.getDescriptor(), e});
                lastExtension = e;
            }
        }
        throw new ResolveException(MessageFormat.format("Could not find extension dependency [{0}]", extensionDependency), lastExtension);
    }

    @Override
    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        TreeSet<Version> versionSet = new TreeSet<Version>();
        for (ExtensionRepository repository : this.repositories.values()) {
            try {
                IterableResult<Version> versions = repository.resolveVersions(id, 0, -1);
                for (Version version : versions) {
                    versionSet.add(version);
                }
            }
            catch (ResolveException e) {
                this.logger.debug("Could not find versions for extension with id [{}]", (Object)id, (Object)e);
            }
        }
        if (versionSet.isEmpty()) {
            throw new ResolveException(MessageFormat.format("Could not find versions for extension with id [{0}]", id));
        }
        return RepositoryUtils.getIterableResult(offset, nb, versionSet);
    }

    @Override
    public IterableResult<Extension> search(String pattern, int offset, int nb) {
        IterableResult<Extension> searchResult = null;
        int currentOffset = offset > 0 ? offset : 0;
        int currentNb = nb;
        for (ExtensionRepository repository : this.repositories.values()) {
            try {
                if ((searchResult = this.search(repository, pattern, currentOffset, currentNb, searchResult)) == null) continue;
                if (currentOffset > 0 && (currentOffset = offset - searchResult.getTotalHits()) < 0) {
                    currentOffset = 0;
                }
                if (currentNb <= 0 || (currentNb = nb - searchResult.getSize()) >= 0) continue;
                currentNb = 0;
            }
            catch (SearchException e) {
                this.logger.error("Failed to search on repository [{}] with pattern=[{}], offset=[{}] and nb=[{}]. Ignore and go to next repository.", new Object[]{repository, pattern, offset, nb, e});
            }
        }
        return searchResult != null ? searchResult : new CollectionIterableResult<Extension>(0, offset, Collections.emptyList());
    }

    private IterableResult<Extension> search(ExtensionRepository repository, String pattern, int offset, int nb, IterableResult<Extension> previousSearchResult) throws SearchException {
        IterableResult<Extension> result;
        if (repository instanceof Searchable) {
            Searchable searchableRepository = (Searchable)((Object)repository);
            result = searchableRepository.search(pattern, offset, nb);
            if (previousSearchResult != null) {
                result = this.appendSearchResults(previousSearchResult, result);
            }
        } else {
            result = previousSearchResult;
        }
        return result;
    }

    private AggregatedIterableResult<Extension> appendSearchResults(IterableResult<Extension> previousSearchResult, IterableResult<Extension> result) {
        AggregatedIterableResult<Extension> newResult;
        if (previousSearchResult instanceof AggregatedIterableResult) {
            newResult = (AggregatedIterableResult<Extension>)previousSearchResult;
        } else {
            newResult = new AggregatedIterableResult<Extension>(previousSearchResult.getOffset());
            newResult.addSearchResult(previousSearchResult);
        }
        newResult.addSearchResult(result);
        return newResult;
    }
}

