/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.util.List;
import org.junit.Before;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlan;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.test.ConfigurableDefaultCoreExtensionRepository;
import org.xwiki.extension.test.RepositoryUtils;
import org.xwiki.job.Job;
import org.xwiki.job.JobManager;
import org.xwiki.job.Request;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.test.jmock.AbstractComponentTestCase;

public abstract class AbstractExtensionHandlerTest
extends AbstractComponentTestCase {
    protected LocalExtensionRepository localExtensionRepository;
    protected InstalledExtensionRepository installedExtensionRepository;
    protected RepositoryUtils repositoryUtil;
    protected JobManager jobManager;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.beforeRepositoryUtil();
        this.repositoryUtil = new RepositoryUtils((ComponentManager)this.getComponentManager(), this.getMockery());
        this.repositoryUtil.setup();
        this.jobManager = (JobManager)this.getComponentManager().getInstance(JobManager.class);
        this.localExtensionRepository = (LocalExtensionRepository)this.getComponentManager().getInstance(LocalExtensionRepository.class);
        this.installedExtensionRepository = (InstalledExtensionRepository)this.getComponentManager().getInstance(InstalledExtensionRepository.class);
    }

    protected void beforeRepositoryUtil() throws Exception {
    }

    protected void registerComponents() throws Exception {
        super.registerComponents();
        this.registerComponent(ConfigurableDefaultCoreExtensionRepository.class);
    }

    protected Job executeJob(String jobId, Request request, LogLevel failFrom) throws Throwable {
        Job installJob = this.jobManager.executeJob(jobId, request);
        List errors = installJob.getStatus().getLog().getLogsFrom(failFrom);
        if (!errors.isEmpty()) {
            throw ((LogEvent)errors.get(0)).getThrowable() != null ? ((LogEvent)errors.get(0)).getThrowable() : new Exception(((LogEvent)errors.get(0)).getFormattedMessage());
        }
        return installJob;
    }

    protected InstalledExtension install(ExtensionId extensionId) throws Throwable {
        return this.install(extensionId, (String[])null, LogLevel.WARN);
    }

    protected InstalledExtension install(ExtensionId extensionId, String[] namespaces) throws Throwable {
        return this.install(extensionId, namespaces, LogLevel.WARN);
    }

    protected InstalledExtension install(ExtensionId extensionId, String namespace) throws Throwable {
        return this.install(extensionId, namespace, LogLevel.WARN);
    }

    protected InstalledExtension install(ExtensionId extensionId, String namespace, LogLevel failFrom) throws Throwable {
        String[] stringArray;
        if (namespace != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = namespace;
        } else {
            stringArray = null;
        }
        return this.install(extensionId, stringArray, failFrom);
    }

    protected InstalledExtension install(ExtensionId extensionId, String[] namespaces, LogLevel failFrom) throws Throwable {
        this.install("install", extensionId, namespaces, failFrom);
        return this.installedExtensionRepository.resolve(extensionId);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId) throws Throwable {
        return this.installPlan(extensionId, null, LogLevel.WARN);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String[] namespaces) throws Throwable {
        return this.installPlan(extensionId, namespaces, LogLevel.WARN);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String namespace) throws Throwable {
        String[] stringArray;
        if (namespace != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = namespace;
        } else {
            stringArray = null;
        }
        return this.installPlan(extensionId, stringArray, LogLevel.WARN);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String[] namespaces, LogLevel failFrom) throws Throwable {
        Job installJob = this.install("installplan", extensionId, namespaces, failFrom);
        return (ExtensionPlan)installJob.getStatus();
    }

    protected Job install(String jobId, ExtensionId extensionId, String[] namespaces, LogLevel failFrom) throws Throwable {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(extensionId.getId());
        installRequest.addExtension(extensionId);
        if (namespaces != null) {
            for (String namespace : namespaces) {
                installRequest.addNamespace(namespace);
            }
        }
        return this.executeJob(jobId, (Request)installRequest, failFrom);
    }

    protected LocalExtension uninstall(ExtensionId extensionId, String namespace) throws Throwable {
        return this.uninstall(extensionId, namespace, LogLevel.WARN);
    }

    protected LocalExtension uninstall(ExtensionId extensionId, String namespace, LogLevel failFrom) throws Throwable {
        this.uninstall("uninstall", extensionId, namespace, failFrom);
        return this.localExtensionRepository.resolve(extensionId);
    }

    protected DefaultExtensionPlan<UninstallRequest> uninstallPlan(ExtensionId extensionId, String namespace, LogLevel failFrom) throws Throwable {
        Job uninstallJob = this.uninstall("installplan", extensionId, namespace, failFrom);
        return (DefaultExtensionPlan)uninstallJob.getStatus();
    }

    protected Job uninstall(String jobId, ExtensionId extensionId, String namespace, LogLevel failFrom) throws Throwable {
        UninstallRequest uninstallRequest = new UninstallRequest();
        uninstallRequest.setId(extensionId.getId());
        uninstallRequest.addExtension(extensionId);
        if (namespace != null) {
            uninstallRequest.addNamespace(namespace);
        }
        return this.executeJob(jobId, (Request)uninstallRequest, failFrom);
    }

    protected ExtensionPlan upgradePlan(String namespace) throws Throwable {
        return this.upgradePlan(namespace, LogLevel.WARN);
    }

    protected ExtensionPlan upgradePlan(String namespace, LogLevel failFrom) throws Throwable {
        InstallRequest installRequest = new InstallRequest();
        if (namespace != null) {
            installRequest.addNamespace(namespace);
        }
        return (ExtensionPlan)this.executeJob("upgradeplan", (Request)installRequest, failFrom).getStatus();
    }
}

