/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.environment.Environment;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.test.ConfigurableDefaultCoreExtensionRepository;
import org.xwiki.extension.test.ExtensionPackager;
import org.xwiki.extension.test.FileExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.test.internal.MockConfigurationSource;

public class RepositoryUtils {
    private static final String MAVENREPOSITORY_ID = "test-maven";
    private final File permanentDirectory;
    private final File temporaryDirectory;
    private final File extensionDirectory;
    private final File localRepositoryRoot;
    private final File mavenRepositoryRoot;
    private final File remoteRepositoryRoot;
    private final ComponentManager componentManager;
    private final Mockery mockery;
    private final ExtensionPackager extensionPackager;
    private FileExtensionRepository remoteRepository;
    private ComponentAnnotationLoader componentLoader;

    public RepositoryUtils() {
        this(null, null);
    }

    public RepositoryUtils(ComponentManager componentManager, Mockery mockery) {
        this.componentManager = componentManager;
        this.mockery = mockery;
        File testDirectory = new File("target/test-" + new Date().getTime());
        this.temporaryDirectory = new File(testDirectory, "temporary-dir");
        this.permanentDirectory = new File(testDirectory, "permanent-dir");
        this.extensionDirectory = new File(this.permanentDirectory, "extension/");
        this.localRepositoryRoot = new File(this.extensionDirectory, "repository/");
        this.mavenRepositoryRoot = new File(testDirectory, "maven/");
        this.remoteRepositoryRoot = new File(testDirectory, "remote/");
        HashMap<String, File> repositories = new HashMap<String, File>();
        repositories.put(null, this.getRemoteRepository());
        repositories.put("remote", this.getRemoteRepository());
        repositories.put("local", this.getLocalRepository());
        this.extensionPackager = new ExtensionPackager(this.permanentDirectory, repositories);
    }

    public File getPermanentDirectory() {
        return this.permanentDirectory;
    }

    public File getTemporaryDirectory() {
        return this.temporaryDirectory;
    }

    public File getExtensionDirectory() {
        return this.extensionDirectory;
    }

    public File getLocalRepository() {
        return this.localRepositoryRoot;
    }

    public File getRemoteRepository() {
        return this.remoteRepositoryRoot;
    }

    public File getMavenRepository() {
        return this.mavenRepositoryRoot;
    }

    public String getMavenRepositoryId() {
        return MAVENREPOSITORY_ID;
    }

    public ExtensionPackager getExtensionPackager() {
        return this.extensionPackager;
    }

    public void setup() throws Exception {
        boolean mavenRepository;
        if (this.componentManager != null) {
            final Environment environment = (Environment)this.mockery.mock(Environment.class);
            this.mockery.checking((ExpectationBuilder)new Expectations(){
                {
                    ((Environment)this.allowing(environment)).getPermanentDirectory();
                    this.will(1.returnValue((Object)RepositoryUtils.this.getPermanentDirectory()));
                    ((Environment)this.allowing(environment)).getTemporaryDirectory();
                    this.will(1.returnValue((Object)RepositoryUtils.this.getTemporaryDirectory()));
                    ((Environment)this.allowing(environment)).getResourceAsStream((String)this.with(1.any(String.class)));
                    this.will(1.returnValue(null));
                }
            });
            DefaultComponentDescriptor dcd = new DefaultComponentDescriptor();
            dcd.setRoleType(Environment.class);
            this.componentManager.registerComponent((ComponentDescriptor)dcd, (Object)environment);
            ConfigurationSource configuration = (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class);
            if (configuration instanceof MockConfigurationSource) {
                ((MockConfigurationSource)configuration).setProperty("extension.repositories", Arrays.asList(""));
            }
            this.registerComponent(ConfigurableDefaultCoreExtensionRepository.class);
            ((ConfigurableDefaultCoreExtensionRepository)((Object)this.componentManager.getInstance(CoreExtensionRepository.class))).addExtensions("coreextension", (Version)new DefaultVersion("version"));
        }
        this.copyResourceFolder(this.getLocalRepository(), "repository.local");
        boolean bl = mavenRepository = this.copyResourceFolder(this.getMavenRepository(), "repository.maven") > 0;
        if (this.componentManager != null) {
            ExtensionRepositoryManager repositoryManager = (ExtensionRepositoryManager)this.componentManager.getInstance(ExtensionRepositoryManager.class);
            if (this.copyResourceFolder(this.getRemoteRepository(), "repository.remote") > 0) {
                this.remoteRepository = new FileExtensionRepository(this.getRemoteRepository(), this.componentManager);
                repositoryManager.addRepository((ExtensionRepository)this.remoteRepository);
            }
            if (mavenRepository) {
                repositoryManager.addRepository((ExtensionRepositoryDescriptor)new DefaultExtensionRepositoryDescriptor(MAVENREPOSITORY_ID, "maven", this.getMavenRepository().toURI()));
            }
        }
        this.extensionPackager.generateExtensions();
        if (this.componentManager != null) {
            ((ExtensionInitializer)this.componentManager.getInstance(ExtensionInitializer.class)).initialize();
        }
    }

    public ComponentAnnotationLoader getComponentLoader() {
        if (this.componentLoader == null) {
            this.componentLoader = new ComponentAnnotationLoader();
        }
        return this.componentLoader;
    }

    private void registerComponent(Class<?> componentClass) throws Exception {
        List descriptors = this.getComponentLoader().getComponentsDescriptors(componentClass);
        for (ComponentDescriptor descriptor : descriptors) {
            this.componentManager.registerComponent(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyResourceFolder(File targetFolder, String resourcePackage) throws IOException {
        int nb = 0;
        targetFolder.mkdirs();
        Set urls = ClasspathHelper.forPackage((String)resourcePackage, (ClassLoader[])new ClassLoader[0]);
        if (!urls.isEmpty()) {
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls((Collection)urls).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)resourcePackage))));
            for (String resource : reflections.getResources(Pattern.compile(".*"))) {
                File targetFile = new File(targetFolder, resource.substring(resourcePackage.length() + 1));
                InputStream resourceStream = this.getClass().getResourceAsStream("/" + resource);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)resourceStream, (File)targetFile);
                    ++nb;
                }
                finally {
                    resourceStream.close();
                }
            }
        }
        return nb;
    }
}

