/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionFile;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionIssueManagement;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionScm;
import org.xwiki.extension.repository.ExtensionRepository;

public abstract class AbstractExtension
implements Extension {
    protected ExtensionId id;
    protected Set<String> features;
    protected String type;
    protected String name;
    protected List<ExtensionLicense> licenses;
    protected String summary;
    protected String description;
    protected List<ExtensionAuthor> authors;
    protected String website;
    protected ExtensionRepository repository;
    protected Map<String, Object> properties;
    protected List<ExtensionDependency> dependencies;
    protected ExtensionScm scm;
    protected ExtensionIssueManagement issueManagement;
    protected ExtensionFile file;

    public AbstractExtension(ExtensionRepository repository, ExtensionId id, String type) {
        this.repository = repository;
        this.id = id;
        this.type = type;
    }

    public AbstractExtension(ExtensionRepository repository, Extension extension) {
        this(repository, extension.getId(), extension.getType());
        this.set(extension);
    }

    protected void set(Extension extension) {
        this.setFeatures(extension.getFeatures());
        this.setName(extension.getName());
        this.setDescription(extension.getDescription());
        this.setAuthors(extension.getAuthors());
        this.setWebsite(extension.getWebSite());
        this.setLicenses(extension.getLicenses());
        this.setSummary(extension.getSummary());
        this.setIssueManagement(extension.getIssueManagement());
        this.setScm(extension.getScm());
        this.setDependencies(extension.getDependencies());
        this.setProperties(extension.getProperties());
    }

    @Override
    public ExtensionId getId() {
        return this.id;
    }

    protected void setId(ExtensionId id) {
        this.id = id;
    }

    @Override
    public Collection<String> getFeatures() {
        return this.features != null ? this.features : Collections.emptyList();
    }

    public void setFeatures(Collection<String> features) {
        this.features = Collections.unmodifiableSet(new HashSet<String>(features));
    }

    public void addFeature(String feature) {
        HashSet<String> newFeatures = new HashSet<String>(this.getFeatures());
        newFeatures.add(feature);
        this.features = Collections.unmodifiableSet(newFeatures);
    }

    @Override
    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Collection<ExtensionLicense> getLicenses() {
        return this.licenses != null ? this.licenses : Collections.emptyList();
    }

    public void setLicenses(Collection<ExtensionLicense> licenses) {
        this.licenses = Collections.unmodifiableList(new ArrayList<ExtensionLicense>(licenses));
    }

    public void addLicense(ExtensionLicense license) {
        ArrayList<ExtensionLicense> newLicenses = new ArrayList<ExtensionLicense>(this.getLicenses());
        newLicenses.add(license);
        this.licenses = Collections.unmodifiableList(newLicenses);
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ExtensionAuthor> getAuthors() {
        return this.authors != null ? this.authors : Collections.emptyList();
    }

    public void setAuthors(Collection<? extends ExtensionAuthor> authors) {
        this.authors = Collections.unmodifiableList(new ArrayList<ExtensionAuthor>(authors));
    }

    public void addAuthor(ExtensionAuthor author) {
        ArrayList<ExtensionAuthor> newAuthors = new ArrayList<ExtensionAuthor>(this.getAuthors());
        newAuthors.add(author);
        this.authors = Collections.unmodifiableList(newAuthors);
    }

    @Override
    public String getWebSite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public void addDependency(ExtensionDependency dependency) {
        ArrayList<ExtensionDependency> newDependencies = new ArrayList<ExtensionDependency>(this.getDependencies());
        newDependencies.add(dependency);
        this.dependencies = Collections.unmodifiableList(newDependencies);
    }

    public List<? extends ExtensionDependency> getDependencies() {
        return this.dependencies != null ? this.dependencies : Collections.emptyList();
    }

    public void setDependencies(Collection<? extends ExtensionDependency> dependencies) {
        this.dependencies = Collections.unmodifiableList(new ArrayList<ExtensionDependency>(dependencies));
    }

    @Override
    public ExtensionRepository getRepository() {
        return this.repository;
    }

    protected void setRepository(ExtensionRepository repository) {
        this.repository = repository;
    }

    @Override
    public ExtensionScm getScm() {
        return this.scm;
    }

    public void setScm(ExtensionScm scm) {
        this.scm = scm;
    }

    @Override
    public ExtensionIssueManagement getIssueManagement() {
        return this.issueManagement;
    }

    public void setIssueManagement(ExtensionIssueManagement issueManagement) {
        this.issueManagement = issueManagement;
    }

    @Override
    public ExtensionFile getFile() {
        return this.file;
    }

    protected void setFile(ExtensionFile file) {
        this.file = file;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties != null ? this.properties : Collections.emptyMap();
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperties().get(key);
    }

    @Override
    public <T> T getProperty(String key, T def) {
        return (T)(this.getProperties().containsKey(key) ? this.getProperties().get(key) : def);
    }

    public void putProperty(String key, Object value) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>(this.getProperties());
        newProperties.put(key, value);
        this.properties = Collections.unmodifiableMap(newProperties);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
    }

    public String toString() {
        return this.getId().toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Extension && this.getId().equals(((Extension)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

