/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Scm;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionIssueManagement;
import org.xwiki.extension.DefaultExtensionScm;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionScmConnection;
import org.xwiki.extension.internal.maven.MavenUtils;
import org.xwiki.extension.repository.internal.core.MavenCoreExtensionDependency;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class ExtensionConverter
extends AbstractConverter<Extension> {
    private static final String UNKNOWN = "unknown";
    @Inject
    private ExtensionLicenseManager licenseManager;
    @Inject
    private ConverterManager converter;

    protected <G extends Extension> G convertToType(Type targetType, Object value) {
        if (value instanceof Model) {
            return (G)this.convertToExtension((Model)value);
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private Extension convertToExtension(Model model) {
        String featuresString;
        IssueManagement issueManagement;
        String version = this.resolveVersion(model.getVersion(), model, false);
        String groupId = this.resolveGroupId(model.getGroupId(), model, false);
        DefaultLocalExtension extension = new DefaultLocalExtension(null, new ExtensionId(groupId + ':' + model.getArtifactId(), version), MavenUtils.packagingToType(model.getPackaging()));
        extension.setName(this.getPropertyString(model, "name", model.getName()));
        extension.setSummary(this.getPropertyString(model, "summary", model.getDescription()));
        extension.setWebsite(this.getPropertyString(model, "website", model.getUrl()));
        for (Developer developer : model.getDevelopers()) {
            URL authorURL = null;
            if (developer.getUrl() != null) {
                try {
                    authorURL = new URL(developer.getUrl());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            extension.addAuthor(new DefaultExtensionAuthor((String)StringUtils.defaultIfBlank((CharSequence)developer.getName(), (CharSequence)developer.getId()), authorURL));
        }
        for (License license : model.getLicenses()) {
            extension.addLicense(this.getExtensionLicense(license));
        }
        Scm scm = model.getScm();
        if (scm != null && (scm.getConnection() != null || scm.getDeveloperConnection() != null || scm.getUrl() != null)) {
            ExtensionScmConnection connection = MavenUtils.toExtensionScmConnection(scm.getConnection());
            ExtensionScmConnection developerConnection = MavenUtils.toExtensionScmConnection(scm.getDeveloperConnection());
            extension.setScm(new DefaultExtensionScm(scm.getUrl(), connection, developerConnection));
        }
        if ((issueManagement = model.getIssueManagement()) != null && issueManagement.getUrl() != null) {
            extension.setIssueManagement(new DefaultExtensionIssueManagement(issueManagement.getSystem(), issueManagement.getUrl()));
        }
        if (StringUtils.isNotBlank((CharSequence)(featuresString = this.getProperty(model, "features")))) {
            featuresString = featuresString.replaceAll("[\r\n]", "");
            extension.setFeatures((Collection)this.converter.convert(List.class, (Object)featuresString));
        }
        for (Dependency dependency : model.getDependencies()) {
            if (dependency.isOptional() || dependency.getScope() != null && !dependency.getScope().equals("compile") && !dependency.getScope().equals("runtime")) continue;
            String dependencyGroupId = this.resolveGroupId(dependency.getGroupId(), model, true);
            String dependencyArtifactId = dependency.getArtifactId();
            String dependencyClassifier = dependency.getClassifier();
            String dependencyVersion = this.resolveVersion(dependency.getVersion(), model, true);
            MavenCoreExtensionDependency extensionDependency = new MavenCoreExtensionDependency(MavenUtils.toExtensionId(dependencyGroupId, dependencyArtifactId, dependencyClassifier), (VersionConstraint)new DefaultVersionConstraint(dependencyVersion), dependency);
            extension.addDependency(extensionDependency);
        }
        extension.putProperty("maven.Model", model);
        for (Map.Entry entry : model.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("xwiki.extension.")) continue;
            extension.putProperty(key, entry.getValue());
        }
        return extension;
    }

    private String getProperty(Model model, String propertyName) {
        return model.getProperties().getProperty("xwiki.extension." + propertyName);
    }

    private String getPropertyString(Model model, String propertyName, String def) {
        return StringUtils.defaultString((String)this.getProperty(model, propertyName), (String)def);
    }

    private ExtensionLicense getExtensionLicense(License license) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        return this.createLicenseByName(license.getName());
    }

    private ExtensionLicense createLicenseByName(String name) {
        ExtensionLicense extensionLicense = this.licenseManager.getLicense(name);
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(name, null);
    }

    private String resolveVersion(String modelVersion, Model mavenModel, boolean dependency) {
        String version = modelVersion;
        if (version == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                version = parent.getVersion();
            }
        } else if (version.startsWith("$")) {
            String propertyName = version.substring(2, version.length() - 1);
            if (propertyName.equals("project.version") || propertyName.equals("pom.version") || propertyName.equals("version")) {
                version = this.resolveVersion(mavenModel.getVersion(), mavenModel, false);
            } else {
                String value = mavenModel.getProperties().getProperty(propertyName);
                if (value != null) {
                    version = value;
                }
            }
        }
        if (version == null) {
            version = UNKNOWN;
        }
        return version;
    }

    private String resolveGroupId(String modelGroupId, Model mavenModel, boolean dependency) {
        String groupId = modelGroupId;
        if (groupId == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                groupId = parent.getGroupId();
            }
        } else if (groupId.startsWith("$")) {
            String propertyName = groupId.substring(2, groupId.length() - 1);
            String value = mavenModel.getProperties().getProperty(propertyName);
            if (value != null) {
                groupId = value;
            }
        }
        if (groupId == null) {
            groupId = UNKNOWN;
        }
        return groupId;
    }
}

