/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.core;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.internal.PathUtils;
import org.xwiki.extension.internal.maven.MavenUtils;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.internal.MavenExtension;
import org.xwiki.extension.repository.internal.core.CoreExtensionCache;
import org.xwiki.extension.repository.internal.core.CoreExtensionScanner;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;
import org.xwiki.extension.repository.internal.core.MavenCoreExtension;
import org.xwiki.properties.ConverterManager;

@Component
@Singleton
public class DefaultCoreExtensionScanner
implements CoreExtensionScanner {
    @Inject
    private Logger logger;
    @Inject
    private ExtensionRepositoryManager repositoryManager;
    @Inject
    private ConverterManager converter;
    @Inject
    private Environment environment;
    @Inject
    private CoreExtensionCache cache;

    private Dependency toDependency(String id, String version, String type) throws ResolveException {
        Matcher matcher = MavenUtils.PARSER_ID.matcher(id);
        if (!matcher.matches()) {
            throw new ResolveException("Bad id " + id + ", expected format is <groupId>:<artifactId>[:<classifier>]");
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(matcher.group(1));
        dependency.setArtifactId(matcher.group(2));
        if (matcher.group(4) != null) {
            dependency.setClassifier(StringUtils.defaultString((String)matcher.group(4), (String)""));
        }
        if (version != null) {
            dependency.setVersion(version);
        }
        if (type != null) {
            dependency.setType(type);
        }
        return dependency;
    }

    private String getArtifactId(DefaultCoreExtension extension) throws ResolveException {
        String artifactId;
        if (extension instanceof MavenExtension) {
            artifactId = ((MavenExtension)((Object)extension)).getMavenArtifactId();
        } else {
            Matcher matcher = MavenUtils.PARSER_ID.matcher(extension.getId().getId());
            if (!matcher.matches()) {
                throw new ResolveException("Bad id " + extension.getId().getId() + ", expected format is <groupId>:<artifactId>[:<classifier>]");
            }
            artifactId = matcher.group(2);
        }
        return artifactId;
    }

    private DefaultCoreExtension getCoreExension(URL descriptorURL, DefaultCoreExtensionRepository repository) throws Exception {
        DefaultCoreExtension coreExtension = this.cache.getExtension(repository, descriptorURL);
        if (coreExtension != null && coreExtension.getDescriptorURL().equals(descriptorURL)) {
            return coreExtension;
        }
        return this.parseMavenPom(descriptorURL, repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultCoreExtension parseMavenPom(URL descriptorURL, DefaultCoreExtensionRepository repository) throws Exception {
        InputStream descriptorStream = descriptorURL.openStream();
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model mavenModel = reader.read(descriptorStream);
            URL extensionURL = PathUtils.getExtensionURL(descriptorURL);
            Extension mavenExtension = (Extension)this.converter.convert(Extension.class, (Object)mavenModel);
            MavenCoreExtension coreExtension = new MavenCoreExtension(repository, extensionURL, mavenExtension);
            coreExtension.setDescriptorURL(descriptorURL);
            if (mavenModel.getParent() == null) {
                this.cache.store(coreExtension);
                coreExtension.setCached(true);
            }
            MavenCoreExtension mavenCoreExtension = coreExtension;
            return mavenCoreExtension;
        }
        finally {
            IOUtils.closeQuietly((InputStream)descriptorStream);
        }
    }

    @Override
    public void updateExtensions(Collection<DefaultCoreExtension> extensions) {
        for (DefaultCoreExtension extension : extensions) {
            if (extension.isCached()) continue;
            try {
                Extension remoteExtension = this.repositoryManager.resolve(extension.getId());
                extension.set(remoteExtension);
                if (extension.getDescriptorURL() == null) continue;
                this.cache.store(extension);
                extension.setCached(true);
            }
            catch (ResolveException e) {
                this.logger.debug("Can't find remote extension with id [{}]", (Object)extension.getId(), (Object)e);
            }
            catch (Exception e) {
                this.logger.warn("Failed to update core extension [{}]: [{}]", new Object[]{extension.getId(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
    }

    @Override
    public Map<String, DefaultCoreExtension> loadExtensions(DefaultCoreExtensionRepository repository) {
        HashMap<String, DefaultCoreExtension> extensions = new HashMap<String, DefaultCoreExtension>();
        this.loadExtensionsFromClassloaders(extensions, repository);
        return extensions;
    }

    /*
     * Exception decompiling
     */
    @Override
    public DefaultCoreExtension loadEnvironmentExtension(DefaultCoreExtensionRepository repository) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadExtensionsFromClassloaders(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtensionRepository repository) {
        Collection mavenURLs = ClasspathHelper.forPackage((String)"META-INF.maven", (ClassLoader[])new ClassLoader[0]);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.setScanners(new Scanner[]{new ResourcesScanner()});
        configurationBuilder.setUrls(mavenURLs);
        configurationBuilder.filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)"META-INF.maven")));
        Reflections reflections = new Reflections((Configuration)configurationBuilder);
        Set descriptors = reflections.getResources(Predicates.equalTo((Object)"pom.xml"));
        for (String descriptor : descriptors) {
            URL descriptorURL = this.getClass().getClassLoader().getResource(descriptor);
            if (descriptorURL != null) {
                try {
                    DefaultCoreExtension coreExtension = this.getCoreExension(descriptorURL, repository);
                    DefaultCoreExtension existingCoreExtension = extensions.get(coreExtension.getId().getId());
                    if (existingCoreExtension == null) {
                        extensions.put(coreExtension.getId().getId(), coreExtension);
                        continue;
                    }
                    this.logger.warn("Collision between core extension [{} ({})] and [{} ({})]", new Object[]{coreExtension.getId(), coreExtension.getDescriptorURL(), existingCoreExtension.getId(), existingCoreExtension.getDescriptorURL()});
                    if (coreExtension.getId().getVersion().compareTo(existingCoreExtension.getId().getVersion()) > 0) {
                        extensions.put(coreExtension.getId().getId(), coreExtension);
                        this.logger.warn("[{} ({})] is selected", (Object)coreExtension.getId(), (Object)coreExtension.getDescriptorURL());
                        continue;
                    }
                    this.logger.warn("[{} ({})] is selected", (Object)existingCoreExtension.getId(), (Object)existingCoreExtension.getDescriptorURL());
                }
                catch (Exception e) {
                    this.logger.warn("Failed to parse extension descriptor [{}] ([{}])", new Object[]{descriptorURL, descriptor, e});
                }
                continue;
            }
            this.logger.error("Could not find resource URL for descriptor [{}]", (Object)descriptor);
        }
        this.guess(extensions, repository);
    }

    private void guess(Map<String, DefaultCoreExtension> extensions, DefaultCoreExtensionRepository repository) {
        HashSet<ExtensionDependency> dependencies = new HashSet<ExtensionDependency>();
        HashSet<String> validaedFiles = new HashSet<String>();
        for (DefaultCoreExtension coreExtension : extensions.values()) {
            validaedFiles.add(coreExtension.getURL().toString());
            for (ExtensionDependency dependency : coreExtension.getDependencies()) {
                if (extensions.containsKey(dependency.getId())) continue;
                dependencies.add(dependency);
            }
        }
        HashMap<String, Object[]> fileNames = new HashMap<String, Object[]>();
        HashMap<String, Object[]> guessedArtefacts = new HashMap<String, Object[]>();
        Collection urls = ClasspathHelper.forClassLoader();
        for (URL url : urls) {
            if (validaedFiles.contains(url.toString())) continue;
            try {
                int index;
                String path = url.toURI().getPath();
                String filename = path.substring(path.lastIndexOf(47) + 1);
                String type = null;
                int extIndex = filename.lastIndexOf(46);
                if (extIndex != -1) {
                    type = filename.substring(extIndex + 1);
                    filename = filename.substring(0, extIndex);
                }
                if ((index = !filename.endsWith("-SNAPSHOT") ? filename.lastIndexOf(45) : filename.lastIndexOf(45, filename.length() - "-SNAPSHOT".length())) == -1) continue;
                fileNames.put(filename, new Object[]{url});
                String artefactname = filename.substring(0, index);
                String version = filename.substring(index + 1);
                guessedArtefacts.put(artefactname, new Object[]{version, url, type});
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse resource name [{}]", (Object)url, (Object)e);
            }
        }
        try {
            for (DefaultCoreExtension coreExtension : extensions.values()) {
                String artifactId = this.getArtifactId(coreExtension);
                Object[] artefact = (Object[])guessedArtefacts.get(artifactId);
                if (artefact == null) continue;
                if (coreExtension.getId().getVersion().getValue().charAt(0) == '$') {
                    coreExtension.setId(new ExtensionId(coreExtension.getId().getId(), (String)artefact[0]));
                    coreExtension.setGuessed(true);
                }
                if (coreExtension.getType().charAt(0) != '$') continue;
                coreExtension.setType((String)artefact[2]);
                coreExtension.setGuessed(true);
            }
            for (ExtensionDependency extensionDependency : dependencies) {
                String dependencyId;
                DefaultCoreExtension coreExtension;
                Dependency dependency = (Dependency)extensionDependency.getProperty("maven.Dependency");
                if (dependency == null) {
                    dependency = this.toDependency(extensionDependency.getId(), extensionDependency.getVersionConstraint().getValue(), null);
                }
                if ((coreExtension = extensions.get(dependencyId = dependency.getGroupId() + ':' + dependency.getArtifactId())) != null) continue;
                String dependencyFileName = dependency.getArtifactId() + '-' + dependency.getVersion();
                if (dependency.getClassifier() != null) {
                    dependencyFileName = dependencyFileName + '-' + dependency.getClassifier();
                    dependencyId = dependencyId + ':' + dependency.getClassifier();
                }
                Object[] filenameArtifact = (Object[])fileNames.get(dependencyFileName);
                Object[] guessedArtefact = (Object[])guessedArtefacts.get(dependency.getArtifactId());
                if (filenameArtifact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)filenameArtifact[0], new ExtensionId(dependencyId, dependency.getVersion()), MavenUtils.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                } else if (guessedArtefact != null) {
                    coreExtension = new DefaultCoreExtension(repository, (URL)guessedArtefact[1], new ExtensionId(dependencyId, (String)guessedArtefact[0]), MavenUtils.packagingToType(dependency.getType()));
                    coreExtension.setGuessed(true);
                }
                if (coreExtension == null) continue;
                extensions.put(dependencyId, coreExtension);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to guess extra information about some extensions", (Throwable)e);
        }
    }
}

