/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.plan.internal;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.ExtensionPlanTree;
import org.xwiki.job.AbstractJobStatus;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.logging.LoggerManager;
import org.xwiki.observation.ObservationManager;

public class DefaultExtensionPlan<R extends ExtensionRequest>
extends AbstractJobStatus<R>
implements ExtensionPlan {
    protected transient ExtensionPlanTree tree;

    public DefaultExtensionPlan(R request, ObservationManager observationManager, LoggerManager loggerManager, ExtensionPlanTree tree, JobStatus parentJobStatus) {
        super(request, parentJobStatus, observationManager, loggerManager);
        this.tree = tree;
    }

    private void fillExtensionActions(Set<ExtensionPlanAction> extensions, Collection<ExtensionPlanNode> nodes) {
        for (ExtensionPlanNode node : nodes) {
            this.fillExtensionActions(extensions, node.getChildren());
            extensions.add(node.getAction());
        }
    }

    @Override
    public ExtensionPlanTree getTree() {
        return this.tree;
    }

    public void setTree(ExtensionPlanTree tree) {
        this.tree = tree;
    }

    @Override
    public Collection<ExtensionPlanAction> getActions() {
        if (this.getState() != JobStatus.State.FINISHED) {
            LinkedHashSet<ExtensionPlanAction> extensions = new LinkedHashSet<ExtensionPlanAction>();
            this.fillExtensionActions(extensions, this.tree);
            return extensions;
        }
        LinkedHashSet<ExtensionPlanAction> actionsCache = new LinkedHashSet<ExtensionPlanAction>();
        this.fillExtensionActions(actionsCache, this.tree);
        return actionsCache;
    }

    public String toString() {
        return this.tree.toString();
    }
}

