/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.ExtensionScmConnection;

public abstract class AbstractExtensionScmConnection
implements ExtensionScmConnection {
    private static final String SCM_PREFIX = "scm:";
    private final String system;
    private final String path;

    public AbstractExtensionScmConnection(String system, String path) {
        this.system = system;
        this.path = path;
    }

    public AbstractExtensionScmConnection(String str) {
        String tempPath = str;
        if (tempPath.startsWith(SCM_PREFIX)) {
            tempPath = tempPath.substring(SCM_PREFIX.length());
        }
        String tempSystem = "git";
        int index = tempPath.indexOf(58);
        if (index >= 0) {
            if (index != 0) {
                tempSystem = tempPath.substring(0, index);
            }
            tempPath = tempPath.substring(index + 1);
        }
        this.path = tempPath;
        this.system = tempSystem;
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExtensionScmConnection) {
            ExtensionScmConnection connection = (ExtensionScmConnection)obj;
            return StringUtils.equals((CharSequence)this.system, (CharSequence)connection.getSystem()) && StringUtils.equals((CharSequence)this.path, (CharSequence)connection.getPath());
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.system);
        builder.append((Object)this.path);
        return builder.toHashCode();
    }

    public String toString() {
        return this.getSystem() + ':' + this.getPath();
    }
}

