/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.spi.connector.ArtifactDownload;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;
import org.xwiki.extension.ExtensionFile;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.plexus.PlexusComponentManager;

public class AetherExtensionFile
implements ExtensionFile {
    private PlexusComponentManager plexusComponentManager;
    private Artifact artifact;
    private AetherExtensionRepository repository;

    public AetherExtensionFile(Artifact artifact, AetherExtensionRepository repository, PlexusComponentManager plexusComponentManager) {
        this.repository = repository;
        this.plexusComponentManager = plexusComponentManager;
        this.artifact = artifact;
    }

    public long getLength() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openStream() throws IOException {
        ArtifactResult artifactResult;
        RepositoryConnector connector;
        RemoteRepositoryManager remoteRepositoryManager;
        RepositorySystem repositorySystem;
        try {
            repositorySystem = (RepositorySystem)this.plexusComponentManager.getPlexus().lookup(RepositorySystem.class);
            remoteRepositoryManager = (RemoteRepositoryManager)this.plexusComponentManager.getPlexus().lookup(RemoteRepositoryManager.class);
        }
        catch (ComponentLookupException e) {
            throw new IOException("Failed to get org.sonatype.aether.RepositorySystem component", e);
        }
        RepositorySystemSession session = this.repository.createRepositorySystemSession();
        try {
            connector = remoteRepositoryManager.getRepositoryConnector(session, this.repository.getRemoteRepository());
        }
        catch (NoRepositoryConnectorException e) {
            throw new IOException("Failed to download artifact [" + this.artifact + "]", e);
        }
        ArtifactDownload download = new ArtifactDownload();
        download.setArtifact(this.artifact);
        download.setRepositories(Arrays.asList(this.repository.getRemoteRepository()));
        try {
            connector.get(Arrays.asList(download), null);
        }
        finally {
            connector.close();
        }
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.addRepository(this.repository.getRemoteRepository());
        artifactRequest.setArtifact(this.artifact);
        try {
            artifactResult = repositorySystem.resolveArtifact(session, artifactRequest);
        }
        catch (ArtifactResolutionException e) {
            throw new IOException("Failed to resolve artifact", e);
        }
        File aetherFile = artifactResult.getArtifact().getFile();
        return new AetherExtensionFileInputStream(aetherFile);
    }

    static class AetherExtensionFileInputStream
    extends FileInputStream {
        private File file;

        public AetherExtensionFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            super.close();
            FileUtils.deleteQuietly((File)this.file);
        }
    }
}

