/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;

public final class AetherUtils {
    private static final Pattern PARSER_ID = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]+))?");

    public static DefaultArtifact createArtifact(String id, String version) throws ResolveException {
        Matcher matcher = PARSER_ID.matcher(id);
        if (!matcher.matches()) {
            throw new ResolveException("Bad id " + id + ", expected format is <groupId>:<artifactId>[:<classifier>]");
        }
        return new DefaultArtifact(matcher.group(1), matcher.group(2), StringUtils.defaultString((String)matcher.group(4), (String)""), "jar", version);
    }

    public static ExtensionId createExtensionId(Artifact artifact) {
        StringBuilder builder = new StringBuilder();
        builder.append(artifact.getGroupId());
        builder.append(':');
        builder.append(artifact.getArtifactId());
        if (StringUtils.isNotEmpty((CharSequence)artifact.getClassifier())) {
            builder.append(':');
            builder.append(artifact.getClassifier());
        }
        return new ExtensionId(builder.toString(), artifact.getVersion());
    }
}

