/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.xwiki;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;

public class UriBuilder
implements Cloneable {
    private String scheme;
    private String host;
    private Integer port;
    private String userInfo;
    private CharSequence path;
    private CharSequence query;
    private String fragment;

    public UriBuilder(URI base, String path) {
        this.uri(base);
        this.path(path);
    }

    public UriBuilder(String base, String path) {
        try {
            this.uri(new URI(base));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid base URI [" + base + "]", e);
        }
        this.path(path);
    }

    private void uri(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        if (uri.getScheme() != null) {
            this.scheme = uri.getScheme();
        }
        if (uri.getHost() != null) {
            this.host = uri.getHost();
        }
        if (uri.getPort() > 0) {
            this.port = uri.getPort();
        }
        if (uri.getRawUserInfo() != null) {
            this.userInfo = uri.getRawUserInfo();
        }
        if (uri.getRawPath() != null) {
            this.path = uri.getRawPath();
        }
        if (uri.getRawQuery() != null) {
            this.query = uri.getRawQuery();
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
    }

    private void path(String path) {
        if (path != null && !path.isEmpty()) {
            StringBuilder stringBuilder;
            if (this.path != null) {
                if (this.path instanceof String) {
                    stringBuilder = new StringBuilder(this.path);
                    this.path = stringBuilder;
                } else {
                    stringBuilder = (StringBuilder)this.path;
                }
            } else {
                stringBuilder = new StringBuilder();
                this.path = stringBuilder;
            }
            if (this.path.length() == 0 || this.path.charAt(this.path.length() - 1) != '/') {
                if (path.charAt(0) != '/') {
                    stringBuilder.append('/');
                }
                stringBuilder.append(path);
            } else {
                int i;
                for (i = 0; i < path.length() && path.charAt(i) == '/'; ++i) {
                }
                if (i > 0) {
                    stringBuilder.append(path.substring(i));
                } else {
                    stringBuilder.append(path);
                }
            }
        }
    }

    public static String encode(String toEncode) {
        String result = null;
        if (toEncode != null) {
            try {
                result = URLEncoder.encode(toEncode, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    public UriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        StringBuilder queryBuilder;
        if (values == null) {
            throw new IllegalArgumentException("The values must not be null");
        }
        String encodedName = UriBuilder.encode(name);
        if (this.query == null) {
            queryBuilder = new StringBuilder();
            this.query = queryBuilder;
        } else if (this.query instanceof StringBuilder) {
            queryBuilder = (StringBuilder)this.query;
        } else {
            queryBuilder = new StringBuilder(this.query);
            this.query = queryBuilder;
        }
        for (Object value : values) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append('&');
            }
            queryBuilder.append(encodedName);
            queryBuilder.append('=');
            queryBuilder.append(UriBuilder.encode(value.toString()));
        }
        return this;
    }

    public URI build(Object ... values) {
        String query;
        String resolvePath;
        StringBuilder stb = new StringBuilder();
        if (this.scheme != null) {
            stb.append(this.scheme);
            stb.append("://");
        }
        if (this.userInfo != null) {
            stb.append(this.userInfo);
            stb.append('@');
        }
        if (this.host != null) {
            stb.append(this.host);
        }
        if (this.port != null) {
            stb.append(':');
            stb.append(this.port);
        }
        if ((resolvePath = this.formatPath(values)) != null) {
            if (stb.length() > 0 && (resolvePath.length() == 0 || resolvePath.charAt(0) != '/')) {
                stb.append('/');
            }
            stb.append(resolvePath);
        }
        String string = query = this.query != null ? ((Object)this.query).toString() : null;
        if (query != null) {
            stb.append('?');
            stb.append(query);
        }
        if (this.fragment != null) {
            stb.append('#');
            stb.append(this.fragment);
        }
        try {
            return new URI(stb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to build the URI", e);
        }
    }

    public static boolean isUnreserved(char character) {
        return Character.isLetter(character) || Character.isDigit(character) || character == '-' || character == '.' || character == '_' || character == '~';
    }

    private String formatPath(Object[] values) {
        StringBuilder result = new StringBuilder();
        StringBuilder varBuffer = null;
        boolean inVariable = false;
        int patternLength = this.path.length();
        int valueId = 0;
        for (int i = 0; i < patternLength; ++i) {
            char c = this.path.charAt(i);
            if (inVariable) {
                if (UriBuilder.isUnreserved(c)) {
                    varBuffer.append(c);
                    continue;
                }
                if (c != '}') continue;
                if (varBuffer.length() != 0) {
                    Object varValue;
                    String varValueString = (varValue = values[valueId++]) == null ? null : varValue.toString();
                    result.append(UriBuilder.encode(varValueString));
                    varBuffer = new StringBuilder();
                }
                inVariable = false;
                continue;
            }
            if (c == '{') {
                inVariable = true;
                varBuffer = new StringBuilder();
                continue;
            }
            if (c == '}') continue;
            result.append(c);
        }
        return result.toString();
    }

    public String toString() {
        return this.build(new Object[0]).toString();
    }

    public UriBuilder clone() {
        UriBuilder clone = null;
        try {
            clone = (UriBuilder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

