/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.groovy.internal;

import groovy.lang.GroovyClassLoader;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.xwiki.component.annotation.Component;
import org.xwiki.groovy.GroovyConfiguration;

@Component(roles={ScriptEngineFactory.class})
@Named(value="groovy")
@Singleton
public class GroovyScriptEngineFactory
extends org.codehaus.groovy.jsr223.GroovyScriptEngineFactory {
    @Inject
    private GroovyConfiguration configuration;

    public ScriptEngine getScriptEngine() {
        GroovyScriptEngineImpl engine = (GroovyScriptEngineImpl)super.getScriptEngine();
        CompilerConfiguration config = new CompilerConfiguration();
        List<CompilationCustomizer> customizers = this.configuration.getCompilationCustomizers();
        if (!customizers.isEmpty()) {
            config.addCompilationCustomizers(customizers.toArray(new CompilationCustomizer[customizers.size()]));
        }
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        GroovyClassLoader loader = new GroovyClassLoader(parentClassLoader, config);
        engine.setClassLoader(loader);
        return engine;
    }
}

