/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.GroupedJobInitializerManager;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.internal.ReadWriteSemaphore;

@Component(roles={JobGroupPathLockTree.class})
@Singleton
public class JobGroupPathLockTree {
    @Inject
    private GroupedJobInitializerManager groupedJobInitializerManager;
    private final Map<JobGroupPath, ReadWriteSemaphore> tree = new ConcurrentHashMap<JobGroupPath, ReadWriteSemaphore>();

    private synchronized ReadWriteSemaphore getSemaphore(JobGroupPath key) {
        ReadWriteSemaphore semaphore = this.tree.get(key);
        if (semaphore == null) {
            semaphore = new ReadWriteSemaphore(this.groupedJobInitializerManager.getGroupedJobInitializer(key).getPoolSize());
            this.tree.put(key, semaphore);
        }
        return semaphore;
    }

    public void lock(JobGroupPath key) {
        this.getSemaphore(key).lockWrite();
        for (JobGroupPath path = key.getParent(); path != null; path = path.getParent()) {
            this.getSemaphore(path).lockRead();
        }
    }

    public void unlock(JobGroupPath key) {
        this.getSemaphore(key).unlockWrite();
        for (JobGroupPath path = key.getParent(); path != null; path = path.getParent()) {
            this.getSemaphore(path).unlockRead();
        }
    }
}

