/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.Request;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.event.status.PopLevelProgressEvent;
import org.xwiki.job.event.status.PushLevelProgressEvent;
import org.xwiki.job.event.status.StepProgressEvent;
import org.xwiki.job.internal.AbstractJobStatus;
import org.xwiki.job.internal.DefaultJobStatus;
import org.xwiki.job.internal.JobStatusStorage;
import org.xwiki.logging.LoggerManager;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public abstract class AbstractJob<R extends Request>
implements Job {
    @Inject
    protected ComponentManager componentManager;
    @Inject
    protected ObservationManager observationManager;
    @Inject
    protected LoggerManager loggerManager;
    @Inject
    protected JobStatusStorage storage;
    @Inject
    protected Logger logger;
    @Inject
    protected JobContext jobContext;
    protected R request;
    protected AbstractJobStatus<R> status;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition finishedCondition = this.lock.newCondition();

    public R getRequest() {
        return this.request;
    }

    @Override
    public JobStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Request request) {
        this.request = this.castRequest(request);
        this.status = this.createNewStatus(this.request);
        this.jobStarting();
        Exception exception = null;
        try {
            this.start();
            this.jobFinished(exception);
        }
        catch (Exception e) {
            try {
                this.logger.error("Exception thrown during job execution", (Throwable)e);
                exception = e;
                this.jobFinished(exception);
            }
            catch (Throwable throwable) {
                this.jobFinished(exception);
                throw throwable;
            }
        }
    }

    protected void jobStarting() {
        this.jobContext.pushCurrentJob(this);
        this.observationManager.notify((Event)new JobStartedEvent(this.getRequest().getId(), this.getType(), (Request)this.request), (Object)this);
        this.status.setStartDate(new Date());
        this.status.setState(JobStatus.State.RUNNING);
        this.status.startListening();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jobFinished(Exception exception) {
        this.lock.lock();
        try {
            this.status.stopListening();
            this.status.setState(JobStatus.State.FINISHED);
            this.status.setStartDate(new Date());
            this.finishedCondition.signalAll();
            this.observationManager.notify((Event)new JobFinishedEvent(this.getRequest().getId(), this.getType(), (Request)this.request), (Object)this, (Object)exception);
            this.jobContext.popCurrentJob();
            try {
                if (this.request.getId() != null) {
                    this.storage.store(this.status);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to store job status [{}]", this.status, (Object)e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected R castRequest(Request request) {
        return (R)request;
    }

    protected AbstractJobStatus<R> createNewStatus(R request) {
        return new DefaultJobStatus<R>(request, this.observationManager, this.loggerManager);
    }

    protected void notifyPushLevelProgress(int steps) {
        this.observationManager.notify((Event)new PushLevelProgressEvent(steps), (Object)this);
    }

    protected void notifyStepPropress() {
        this.observationManager.notify((Event)new StepProgressEvent(), (Object)this);
    }

    protected void notifyPopLevelProgress() {
        this.observationManager.notify((Event)new PopLevelProgressEvent(), (Object)this);
    }

    protected abstract void start() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void join() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.getStatus() == null || this.getStatus().getState() != JobStatus.State.FINISHED) {
                this.finishedCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean join(long time, TimeUnit unit) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.getStatus().getState() != JobStatus.State.FINISHED) {
                boolean bl = this.finishedCondition.await(time, unit);
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }
}

