/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeArrayConverter
extends ArrayConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeArrayConverter.class);

    public SafeArrayConverter(Mapper mapper) {
        super(mapper);
    }

    public boolean canConvert(Class type) {
        return type == Object[].class;
    }

    protected Object readItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
        Object value;
        try {
            value = super.readItem(reader, context, current);
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to read field", e);
            value = null;
        }
        return value;
    }

    protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
        try {
            super.writeItem(item, context, writer);
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to write field", e);
        }
    }
}

