/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.job.internal.xstream.SafeXStream;

public class SafeTreeMarshaller
extends TreeMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeTreeMarshaller.class);
    private SafeXStream xstream;

    public SafeTreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper, SafeXStream xstream) {
        super(writer, converterLookup, mapper);
        this.xstream = xstream;
    }

    private ObjectIdDictionary getParentObjects() {
        ObjectIdDictionary parentObjects = (ObjectIdDictionary)this.get(ObjectIdDictionary.class);
        if (parentObjects == null) {
            parentObjects = new ObjectIdDictionary();
            this.put(ObjectIdDictionary.class, parentObjects);
        }
        return parentObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convert(Object item, Converter converter) {
        ObjectIdDictionary parentObjects = this.getParentObjects();
        if (parentObjects.containsId(item)) {
            TreeMarshaller.CircularReferenceException e = new TreeMarshaller.CircularReferenceException("Recursive reference to parent object");
            e.add("item-type", item.getClass().getName());
            e.add("converter-type", converter.getClass().getName());
            throw e;
        }
        parentObjects.associateId(item, (Object)"");
        try {
            super.convert(item, converter);
        }
        finally {
            parentObjects.removeId(item);
        }
    }
}

