/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JobGroupPath {
    private final JobGroupPath parent;
    private final List<String> path;

    public JobGroupPath(Collection<String> path) {
        this.path = Collections.unmodifiableList(new ArrayList<String>(path));
        this.parent = this.path.size() > 1 ? new JobGroupPath(this.path.subList(0, this.path.size() - 1)) : null;
    }

    public JobGroupPath(String element, JobGroupPath parent) {
        ArrayList<String> list;
        this.parent = parent;
        if (parent == null) {
            list = new ArrayList<String>(1);
        } else {
            list = new ArrayList(parent.getPath().size() + 1);
            list.addAll(parent.getPath());
        }
        list.add(element);
        this.path = Collections.unmodifiableList(list);
    }

    public List<String> getPath() {
        return this.path;
    }

    public JobGroupPath getParent() {
        return this.parent;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JobGroupPath) {
            return this.path.equals(((JobGroupPath)obj).getPath());
        }
        return false;
    }

    public String toString() {
        return StringUtils.join(this.path, (char)'/');
    }
}

