/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.job.event.status.EndStepProgressEvent;
import org.xwiki.job.event.status.JobProgress;
import org.xwiki.job.event.status.PopLevelProgressEvent;
import org.xwiki.job.event.status.PushLevelProgressEvent;
import org.xwiki.job.event.status.StartStepProgressEvent;
import org.xwiki.job.event.status.StepProgressEvent;
import org.xwiki.job.internal.DefaultJobProgressStep;
import org.xwiki.logging.Message;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

public class DefaultJobProgress
implements EventListener,
JobProgress {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJobProgress.class);
    private static final List<Event> EVENTS = Arrays.asList(new PushLevelProgressEvent(), PopLevelProgressEvent.INSTANCE, StepProgressEvent.INSTANCE, StartStepProgressEvent.INSTANCE, EndStepProgressEvent.INSTANCE);
    private final String listenerName;
    private final DefaultJobProgressStep rootStep;
    private DefaultJobProgressStep currentStep;

    public DefaultJobProgress() {
        this(null);
    }

    public DefaultJobProgress(String name) {
        this.listenerName = name != null ? name : this.getClass().getName() + '_' + System.identityHashCode(this);
        this.currentStep = this.rootStep = new DefaultJobProgressStep(new Message("job.progress", "Progress with name [{}]", new Object[]{name}), null, null);
    }

    public String getName() {
        return this.listenerName;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object message) {
        if (event instanceof PushLevelProgressEvent) {
            this.onPushLevelProgress(((PushLevelProgressEvent)event).getSteps(), source);
        } else if (event instanceof PopLevelProgressEvent) {
            this.onPopLevelProgress(source);
        } else if (event instanceof StartStepProgressEvent) {
            this.onStartStepProgress((Message)message, source);
        } else if (event instanceof EndStepProgressEvent) {
            this.onEndStepProgress(source);
        } else if (event instanceof StepProgressEvent) {
            this.onStepProgress(source);
        }
    }

    private void onPushLevelProgress(int steps, Object source) {
        if (this.currentStep.isLevelFinished()) {
            this.currentStep = this.currentStep.getParent().nextStep(null, source);
        }
        this.currentStep = this.currentStep.addLevel(steps, source);
    }

    private void onEndStepProgress(Object source) {
        DefaultJobProgressStep step = this.findStep(this.currentStep, source);
        if (step == null) {
            LOGGER.warn("Could not find any matching step for source [{}]. Ignoring EndStepProgress.", (Object)source.toString());
            return;
        }
        this.currentStep = step;
        this.currentStep.finish();
    }

    private void onStartStepProgress(Message message, Object source) {
        if (this.currentStep.getParent() == null) {
            this.currentStep = this.currentStep.addLevel(source);
        } else if (!this.currentStep.isLevelFinished() && this.currentStep.source != source) {
            this.onPushLevelProgress(0, source);
        }
        this.currentStep = this.currentStep.getParent().nextStep(message, source);
    }

    @Deprecated
    private void onStepProgress(Object source) {
        this.onStartStepProgress(null, source);
        if (this.currentStep.getParent().getChildren().size() == 1) {
            this.currentStep = this.currentStep.getParent().nextStep(null, source);
        }
    }

    private void onPopLevelProgress(Object source) {
        DefaultJobProgressStep parent = this.currentStep.getParent();
        if (parent == null) {
            LOGGER.warn("PopLevelProgressEvent was fired too many times. Don't forget to match each PopLevelProgressEvent with a PushLevelProgressEvent.");
            return;
        }
        DefaultJobProgressStep level = this.findLevel(this.currentStep.getParent(), source);
        if (level == null) {
            LOGGER.warn("Could not find any matching step level for source [{}]. Ignoring PopLevelProgressEvent.", (Object)source.toString());
            return;
        }
        this.currentStep = level;
        this.currentStep.finishLevel();
    }

    private DefaultJobProgressStep findStep(DefaultJobProgressStep step, Object source) {
        DefaultJobProgressStep matchingStep = step;
        do {
            if (matchingStep.source != source) continue;
            return matchingStep;
        } while ((matchingStep = matchingStep.getParent()) != null);
        return null;
    }

    private DefaultJobProgressStep findLevel(DefaultJobProgressStep step, Object levelSource) {
        DefaultJobProgressStep matchingStep = step;
        do {
            if (levelSource != null && matchingStep.levelSource != levelSource) continue;
            return matchingStep;
        } while ((matchingStep = matchingStep.getParent()) != null);
        return null;
    }

    @Override
    public double getOffset() {
        return this.rootStep.getOffset();
    }

    @Override
    public double getCurrentLevelOffset() {
        return this.currentStep.getParent() != null ? this.currentStep.getParent().getOffset() : this.getOffset();
    }

    @Override
    public DefaultJobProgressStep getRootStep() {
        return this.rootStep;
    }

    @Override
    public DefaultJobProgressStep getCurrentStep() {
        return this.currentStep;
    }
}

