/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.BeginLogEvent;
import org.xwiki.logging.event.LogEvent;

public class LogTreeNode
extends BeginLogEvent
implements Iterable<LogEvent>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ConcurrentLinkedQueue<LogEvent> children;

    LogTreeNode() {
    }

    public LogTreeNode(LogEvent logEvent) {
        super(logEvent);
    }

    @Override
    public Iterator<LogEvent> iterator() {
        return this.children != null ? this.children.iterator() : Collections.emptyList().iterator();
    }

    public Iterator<LogEvent> iterator(boolean recurse) {
        if (!recurse) {
            return this.iterator();
        }
        return new LogTreeNodeIterator(this.iterator());
    }

    public int size(boolean recurse) {
        if (!recurse) {
            return this.children != null ? this.children.size() : 0;
        }
        int size = 0;
        for (LogEvent logEvent : this) {
            ++size;
            if (!(logEvent instanceof LogTreeNode)) continue;
            size += ((LogTreeNode)logEvent).size(true);
        }
        return size;
    }

    void add(LogEvent logEvent) {
        if (this.children == null) {
            this.children = new ConcurrentLinkedQueue();
        }
        this.children.add(logEvent);
    }

    public List<LogEvent> getLogs(LogLevel level, boolean recurse) {
        LinkedList<LogEvent> levelLogs = new LinkedList<LogEvent>();
        for (LogEvent log : this) {
            if (log.getLevel() == level) {
                levelLogs.add(log);
            }
            if (!recurse || !(log instanceof LogTreeNode)) continue;
            levelLogs.addAll(((LogTreeNode)log).getLogs(level, true));
        }
        return levelLogs;
    }

    public List<LogEvent> getLogsFrom(LogLevel level, boolean recurse) {
        LinkedList<LogEvent> levelLogs = new LinkedList<LogEvent>();
        for (LogEvent log : this) {
            if (log.getLevel().compareTo(level) <= 0) {
                levelLogs.add(log);
            }
            if (!recurse || !(log instanceof LogTreeNode)) continue;
            levelLogs.addAll(((LogTreeNode)log).getLogsFrom(level, true));
        }
        return levelLogs;
    }

    private static class LogTreeNodeIterator
    implements Iterator<LogEvent> {
        private final Iterator<LogEvent> rootIterator;
        private Iterator<LogEvent> currentIterator;

        LogTreeNodeIterator(Iterator<LogEvent> rootIterator) {
            this.rootIterator = rootIterator;
            this.currentIterator = this.rootIterator;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext() || this.rootIterator.hasNext();
        }

        @Override
        public LogEvent next() {
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = this.rootIterator;
            }
            LogEvent logEvent = this.currentIterator.next();
            if (this.currentIterator == this.rootIterator && logEvent instanceof LogTreeNode) {
                this.currentIterator = ((LogTreeNode)logEvent).iterator(true);
            }
            return logEvent;
        }

        @Override
        public void remove() {
            this.currentIterator.remove();
        }
    }
}

