/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogQueue;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.internal.tail.XStreamFileLoggerTail;
import org.xwiki.logging.logback.internal.ForbiddenThreadsFilter;
import org.xwiki.logging.logback.internal.LogbackEventGenerator;
import org.xwiki.logging.logback.internal.LogbackUtils;
import org.xwiki.logging.tail.LoggerTail;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.WrappedThreadEventListener;

@Component
@Singleton
public class DefaultLoggerManager
implements LoggerManager,
Initializable {
    @Inject
    private ObservationManager observation;
    @Inject
    private Provider<XStreamFileLoggerTail> loggerTailProvider;
    @Inject
    private Logger logger;
    private ThreadLocal<Deque<EventListener>> listeners = new ThreadLocal();
    private LogbackUtils utils = new LogbackUtils();
    private ForbiddenThreadsFilter forbiddenThreads = new ForbiddenThreadsFilter();

    public void initialize() throws InitializationException {
        ch.qos.logback.classic.Logger rootLogger = this.getRootLogger();
        if (rootLogger != null) {
            Iterator iterator = rootLogger.iteratorForAppenders();
            while (iterator.hasNext()) {
                Appender appender = (Appender)iterator.next();
                if (appender instanceof LogbackEventGenerator) continue;
                appender.addFilter((Filter)this.forbiddenThreads);
            }
        } else {
            this.logger.warn("Could not find any Logback root logger. All logging module advanced features will be disabled.");
        }
    }

    public void pushLogListener(EventListener listener) {
        Deque<EventListener> listenerStack = this.listeners.get();
        if (listenerStack == null) {
            listenerStack = new LinkedList<EventListener>();
            this.listeners.set(listenerStack);
        }
        if (!listenerStack.isEmpty()) {
            this.observation.removeListener(listenerStack.peek().getName());
        }
        if (listener != null) {
            this.observation.addListener((EventListener)new WrappedThreadEventListener(listener));
        }
        if (listenerStack.isEmpty()) {
            this.grabLog(Thread.currentThread());
        }
        listenerStack.push(listener);
    }

    public EventListener popLogListener() {
        EventListener listener;
        Deque<EventListener> listenerStack = this.listeners.get();
        if (listenerStack != null && !listenerStack.isEmpty()) {
            listener = listenerStack.pop();
            if (listener != null) {
                this.observation.removeListener(listener.getName());
            }
            if (listenerStack.isEmpty()) {
                this.ungrabLog(Thread.currentThread());
            } else {
                EventListener topListener = listenerStack.peek();
                if (topListener != null) {
                    this.observation.addListener((EventListener)new WrappedThreadEventListener(topListener));
                }
            }
        } else {
            listener = null;
        }
        return listener;
    }

    private void grabLog(Thread thread) {
        this.forbiddenThreads.addThread(thread);
    }

    private void ungrabLog(Thread thread) {
        this.forbiddenThreads.removeThread(thread);
    }

    public void setLoggerLevel(String loggerName, LogLevel logLevel) {
        LoggerContext loggerContext = this.utils.getLoggerContext();
        if (loggerContext != null) {
            ch.qos.logback.classic.Logger askedLogger = loggerContext.getLogger(loggerName);
            askedLogger.setLevel(this.utils.toLevel(logLevel));
        }
    }

    public LogLevel getLoggerLevel(String loggerName) {
        ch.qos.logback.classic.Logger askedLogger;
        LoggerContext loggerContext = this.getLoggerContext();
        if (loggerContext != null && (askedLogger = loggerContext.exists(loggerName)) != null) {
            return this.utils.toLogLevel(askedLogger.getLevel());
        }
        return null;
    }

    public Collection<Logger> getLoggers() {
        return this.utils.getLoggerContext().getLoggerList();
    }

    protected ch.qos.logback.classic.Logger getRootLogger() {
        return this.utils.getRootLogger();
    }

    protected LoggerContext getLoggerContext() {
        return this.utils.getLoggerContext();
    }

    public LoggerTail createLoggerTail(Path path, boolean readonly) throws IOException {
        if (readonly && !XStreamFileLoggerTail.exist((Path)path)) {
            return new LogQueue();
        }
        XStreamFileLoggerTail loggerTail = (XStreamFileLoggerTail)this.loggerTailProvider.get();
        loggerTail.initialize(path, readonly);
        return loggerTail;
    }
}

