/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.Before;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.ComponentDescriptorFactory;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.test.AbstractMockingTestCase;
import org.xwiki.test.annotation.MockingRequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMockingComponentTestCase
extends AbstractMockingTestCase {
    private EmbeddableComponentManager componentManager;
    private ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
    private ComponentDescriptorFactory factory = new ComponentDescriptorFactory();

    @Before
    public void setUp() throws Exception {
        this.componentManager = new EmbeddableComponentManager();
        this.loader.initialize((ComponentManager)this.componentManager, this.getClass().getClassLoader());
        block0: for (Field field : ReflectionUtils.getAllFields(this.getClass())) {
            MockingRequirement mockingRequirement = field.getAnnotation(MockingRequirement.class);
            if (mockingRequirement == null) continue;
            Class<?> componentRoleClass = this.findComponentRoleClass(field, mockingRequirement);
            for (ComponentDescriptor descriptor : this.factory.createComponentDescriptors(field.getType(), componentRoleClass)) {
                if ((mockingRequirement.hint().length() <= 0 || !mockingRequirement.hint().equals(descriptor.getRoleHint())) && mockingRequirement.hint().length() != 0) continue;
                this.registerMockDependencies(descriptor, mockingRequirement);
                this.getComponentManager().registerComponent(descriptor);
                this.configure();
                ReflectionUtils.setFieldValue((Object)this, (String)field.getName(), (Object)this.getComponentManager().lookup(descriptor.getRole(), descriptor.getRoleHint()));
                continue block0;
            }
        }
    }

    public void configure() throws Exception {
    }

    private <T> void registerMockDependencies(ComponentDescriptor<T> descriptor, MockingRequirement mockingRequirement) throws Exception {
        List<Class<?>> exceptions = Arrays.asList(mockingRequirement.exceptions());
        Collection dependencyDescriptors = descriptor.getComponentDependencies();
        for (ComponentDependency dependencyDescriptor : dependencyDescriptors) {
            if (exceptions.contains(dependencyDescriptor.getRole())) continue;
            DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
            cd.setRole(dependencyDescriptor.getRole());
            cd.setRoleHint(dependencyDescriptor.getRoleHint());
            this.componentManager.registerComponent((ComponentDescriptor)cd, this.getMockery().mock(dependencyDescriptor.getRole(), dependencyDescriptor.getName()));
        }
    }

    private Class<?> findComponentRoleClass(Field field, MockingRequirement mockingRequirement) {
        Class componentRoleClass;
        Set componentRoleClasses = this.loader.findComponentRoleClasses(field.getType());
        if (!Object.class.getName().equals(mockingRequirement.value().getName())) {
            if (!componentRoleClasses.contains(mockingRequirement.value())) {
                throw new RuntimeException("Specified Component Role not found in component");
            }
            componentRoleClass = mockingRequirement.value();
        } else {
            if (componentRoleClasses.isEmpty()) {
                throw new RuntimeException("Couldn't find roles for component [" + field.getType() + "]");
            }
            if (componentRoleClasses.size() > 1) {
                throw new RuntimeException("Components with several roles must explicitely specify which role to use.");
            }
            componentRoleClass = (Class)componentRoleClasses.iterator().next();
        }
        return componentRoleClass;
    }

    public EmbeddableComponentManager getComponentManager() throws Exception {
        return this.componentManager;
    }
}

