/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.configuration.ConfigurationSource;

public class MockConfigurationSource
implements ConfigurationSource {
    private Map<String, Object> properties = new HashMap<String, Object>();

    public static DefaultComponentDescriptor<ConfigurationSource> getDescriptor(String roleHint) {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setRole(ConfigurationSource.class);
        if (roleHint != null) {
            descriptor.setRoleHint(roleHint);
        }
        descriptor.setImplementation(MockConfigurationSource.class);
        return descriptor;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.properties.keySet());
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        Object result = null;
        if (this.properties.containsKey(key)) {
            result = this.properties.get(key);
        } else if (List.class.getName().equals(valueClass.getName())) {
            result = Collections.emptyList();
        } else if (Properties.class.getName().equals(valueClass.getName())) {
            result = new Properties();
        }
        return (T)result;
    }

    public <T> T getProperty(String key, T defaultValue) {
        return (T)(this.properties.containsKey(key) ? this.properties.get(key) : defaultValue);
    }

    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }
}

