/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Before;
import org.slf4j.Logger;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.ComponentDeclaration;
import org.xwiki.component.annotation.ComponentDescriptorFactory;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.test.AbstractMockingTestCase;
import org.xwiki.test.MockingComponentManager;
import org.xwiki.test.annotation.AllComponents;
import org.xwiki.test.annotation.ComponentList;
import org.xwiki.test.annotation.MockingRequirement;
import org.xwiki.test.annotation.MockingRequirements;

public abstract class AbstractMockingComponentTestCase<T>
extends AbstractMockingTestCase {
    private MockingComponentManager componentManager;
    private ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
    private ComponentDescriptorFactory factory = new ComponentDescriptorFactory();
    private Map<Class, Logger> mockLoggers = new HashMap<Class, Logger>();
    private Map<Class, RoleHint<T>> mockedComponents = new HashMap<Class, RoleHint<T>>();

    public T getMockedComponent() throws ComponentLookupException {
        if (this.mockedComponents.size() == 0) {
            throw new RuntimeException("You need to have at least one @MockingRequirement annotation!");
        }
        if (this.mockedComponents.size() > 1) {
            throw new RuntimeException("When there are several @MockingRequirement annotations you muse use the getMockedComponent(mockedComponentClass) signature!");
        }
        return this.getMockedComponent(this.mockedComponents.keySet().iterator().next());
    }

    public T getMockedComponent(Class mockedComponentClass) throws ComponentLookupException {
        RoleHint<T> roleHint = this.mockedComponents.get(mockedComponentClass);
        return (T)this.componentManager.getInstance(roleHint.getRoleType(), roleHint.getHint());
    }

    public Logger getMockLogger(Class<?> mockedComponentClass) throws Exception {
        return this.mockLoggers.get(mockedComponentClass);
    }

    public Logger getMockLogger() throws Exception {
        if (this.mockLoggers.size() == 1) {
            return this.mockLoggers.values().iterator().next();
        }
        if (this.mockLoggers.size() == 0) {
            throw new RuntimeException("You have excluded the Logger from being mocked in your @MockingRequirement!");
        }
        throw new RuntimeException("When there are several @MockingRequirement annotations you muse use the getMockLogger(mockRequirementInstanceClass) signature!");
    }

    @Before
    public void setUp() throws Exception {
        this.componentManager = new LogSpecificMockingComponentManager();
        this.registerComponents();
        block0: for (MockingRequirement mockingRequirement : this.getMockingRequirements()) {
            List<Class<?>> exclusions = Arrays.asList(mockingRequirement.exceptions());
            if (!exclusions.contains(Logger.class)) {
                ((LogSpecificMockingComponentManager)this.componentManager).addMockedComponentClass(mockingRequirement.value());
            }
            Type componentRoleType = this.findComponentRoleType(mockingRequirement);
            for (ComponentDescriptor descriptor : this.factory.createComponentDescriptors(mockingRequirement.value(), componentRoleType)) {
                if ((mockingRequirement.hint().length() <= 0 || !mockingRequirement.hint().equals(descriptor.getRoleHint())) && mockingRequirement.hint().length() != 0) continue;
                this.registerMockDependencies(descriptor, exclusions);
                this.getComponentManager().registerComponent(descriptor);
                this.mockedComponents.put(mockingRequirement.value(), new RoleHint(descriptor.getRoleType(), descriptor.getRoleHint()));
                continue block0;
            }
        }
    }

    private List<MockingRequirement> getMockingRequirements() {
        List<MockingRequirement> mockingRequirements;
        MockingRequirements mockingRequirementsAnnotation = this.getClass().getAnnotation(MockingRequirements.class);
        if (mockingRequirementsAnnotation != null) {
            mockingRequirements = Arrays.asList(mockingRequirementsAnnotation.value());
        } else {
            MockingRequirement mockingRequirementAnnotation = this.getClass().getAnnotation(MockingRequirement.class);
            if (mockingRequirementAnnotation != null) {
                mockingRequirements = Collections.singletonList(mockingRequirementAnnotation);
            } else {
                throw new RuntimeException("When extending " + AbstractMockingComponentTestCase.class.getSimpleName() + " you must have at least one @" + MockingRequirement.class.getSimpleName() + ".");
            }
        }
        return mockingRequirements;
    }

    private void registerComponents() {
        AllComponents allComponentsAnnotation = this.getClass().getAnnotation(AllComponents.class);
        if (allComponentsAnnotation != null) {
            this.loader.initialize((ComponentManager)this.componentManager, this.getClass().getClassLoader());
        } else {
            ComponentList componentListAnnotation = this.getClass().getAnnotation(ComponentList.class);
            if (componentListAnnotation != null) {
                ArrayList<ComponentDeclaration> componentDeclarations = new ArrayList<ComponentDeclaration>();
                for (Class<?> componentClass : componentListAnnotation.value()) {
                    componentDeclarations.add(new ComponentDeclaration(componentClass.getName()));
                }
                this.loader.initialize((ComponentManager)this.componentManager, this.getClass().getClassLoader(), componentDeclarations);
            }
        }
    }

    private <T> void registerMockDependencies(ComponentDescriptor<T> descriptor, List<Class<?>> exceptions) throws Exception {
        Collection dependencyDescriptors = descriptor.getComponentDependencies();
        for (ComponentDependency dependencyDescriptor : dependencyDescriptors) {
            Class roleTypeClass = ReflectionUtils.getTypeClass((Type)dependencyDescriptor.getRoleType());
            if (exceptions.contains(roleTypeClass) || Logger.class == roleTypeClass || roleTypeClass.isAssignableFrom(List.class) || roleTypeClass.isAssignableFrom(Map.class)) continue;
            DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
            cd.setRoleType(dependencyDescriptor.getRoleType());
            cd.setRoleHint(dependencyDescriptor.getRoleHint());
            this.componentManager.registerComponent((ComponentDescriptor)cd, this.getMockery().mock(ReflectionUtils.getTypeClass((Type)dependencyDescriptor.getRoleType()), dependencyDescriptor.getName()));
        }
    }

    private Type findComponentRoleType(MockingRequirement mockingRequirement) {
        Type componentRoleType;
        Set componentRoleTypes = this.loader.findComponentRoleTypes(mockingRequirement.value());
        Class<?> role = mockingRequirement.role();
        if (!Object.class.getName().equals(role.getName())) {
            if (!componentRoleTypes.contains(role)) {
                throw new RuntimeException("Specified Component Role not found in component");
            }
            componentRoleType = role;
        } else {
            if (componentRoleTypes.isEmpty()) {
                throw new RuntimeException(String.format("Couldn't find roles for component [%s]", mockingRequirement.value()));
            }
            if (componentRoleTypes.size() > 1) {
                throw new RuntimeException("Components with several roles must explicitly specify which role to use.");
            }
            componentRoleType = (Type)componentRoleTypes.iterator().next();
        }
        return componentRoleType;
    }

    @Override
    public MockingComponentManager getComponentManager() throws Exception {
        return this.componentManager;
    }

    private class LogSpecificMockingComponentManager
    extends MockingComponentManager {
        private List<Class<?>> mockedComponentClasses = new ArrayList();

        private LogSpecificMockingComponentManager() {
        }

        public void addMockedComponentClass(Class<?> mockedComponentClass) {
            this.mockedComponentClasses.add(mockedComponentClass);
        }

        protected Object createLogger(Class<?> instanceClass) {
            Object logger;
            if (this.mockedComponentClasses.contains(instanceClass)) {
                logger = AbstractMockingComponentTestCase.this.getMockery().mock(Logger.class, instanceClass.getName());
                AbstractMockingComponentTestCase.this.mockLoggers.put(instanceClass, (Logger)logger);
            } else {
                logger = super.createLogger(instanceClass);
            }
            return logger;
        }
    }
}

