/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.spoon;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.tool.spoon.AbstractXWikiProcessor;
import org.xwiki.tool.spoon.SpoonUtils;
import spoon.SpoonException;
import spoon.processing.Property;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;

public class ComponentAnnotationProcessor
extends AbstractXWikiProcessor<CtClass<?>> {
    private static final String COMPONENT_ANNOTATION = "org.xwiki.component.annotation.Component";
    private static final String SINGLETON_ANNOTATION = "javax.inject.Singleton";
    private static final String INSTANTIATION_STRATEGY_ANNOTATION = "org.xwiki.component.annotation.InstantiationStrategy";
    private Path resolvedComponentsTxtPath;
    private List<String> registeredComponentNames;
    private List<String> assertedComponentNames = new ArrayList<String>();
    private String componentsDeclarationLocation;
    @Property
    private String componentsTxtPath;
    @Property
    private String skipForeignDeclarations;

    public void process(CtClass<?> ctClass) {
        String qualifiedName = ctClass.getQualifiedName();
        boolean hasComponentAnnotation = false;
        boolean isStaticRegistration = true;
        boolean hasInstantiationStrategyAnnotation = false;
        boolean hasSingletonAnnotation = false;
        for (CtAnnotation<? extends Annotation> annotation : SpoonUtils.getAnnotationsIncludingFromSuperclasses(ctClass)) {
            if (COMPONENT_ANNOTATION.equals(annotation.getAnnotationType().getQualifiedName())) {
                hasComponentAnnotation = true;
                if (!"false".equals(annotation.getValue("staticRegistration").toString())) continue;
                isStaticRegistration = false;
                continue;
            }
            if (INSTANTIATION_STRATEGY_ANNOTATION.equals(annotation.getAnnotationType().getQualifiedName())) {
                hasInstantiationStrategyAnnotation = true;
                continue;
            }
            if (!SINGLETON_ANNOTATION.equals(annotation.getAnnotationType().getQualifiedName())) continue;
            hasSingletonAnnotation = true;
        }
        if (hasComponentAnnotation) {
            if (this.registeredComponentNames == null) {
                this.registeredComponentNames = this.parseComponentsTxtFile(qualifiedName, ctClass, isStaticRegistration);
            }
            if (!isStaticRegistration) {
                this.check2B(qualifiedName);
            } else {
                this.check2A(qualifiedName);
            }
            this.check3A(qualifiedName, hasInstantiationStrategyAnnotation, hasSingletonAnnotation);
            this.assertedComponentNames.add(qualifiedName);
        }
    }

    @Override
    public void processingDone() {
        if (this.skipForeignDeclarations == null || !Boolean.parseBoolean(this.skipForeignDeclarations)) {
            this.check2D();
        }
        super.processingDone();
    }

    private void check2D() {
        if (this.registeredComponentNames != null) {
            for (String componentName : this.registeredComponentNames) {
                if (this.assertedComponentNames.contains(componentName)) continue;
                this.registerError(String.format("Component [%s] is declared in [%s] but it's missing a @Component declaration or its source code wasn't found in the current Maven module", componentName, this.resolvedComponentsTxtPath));
            }
        }
    }

    private void check3A(String qualifiedName, boolean hasInstantiationStrategyAnnotation, boolean hasSingletonAnnotation) {
        if (!hasInstantiationStrategyAnnotation && !hasSingletonAnnotation) {
            this.registerError(String.format("Component class [%s] must have either the [%s] or the [%s] annotation defined on it.", qualifiedName, SINGLETON_ANNOTATION, INSTANTIATION_STRATEGY_ANNOTATION));
        }
    }

    private void check2A(String qualifiedName) {
        if (!this.registeredComponentNames.contains(qualifiedName)) {
            this.registerError(String.format("Component [%s] is not declared in [%s]! Consider adding it or if it is normal use the \"staticRegistration\" parameter as in \"@Component(staticRegistration = false)\"", qualifiedName, this.componentsDeclarationLocation));
        }
    }

    private void check2B(String qualifiedName) {
        if (this.registeredComponentNames.contains(qualifiedName)) {
            this.registerError(String.format("Component [%s] is declared in [%s] but it is also declared with a \"staticRegistration\" parameter with a [false] value, e.g. \"@Component(staticRegistration = false\". You need to fix that!", qualifiedName, this.componentsDeclarationLocation));
        }
    }

    private List<String> parseComponentsTxtFile(String qualifiedName, CtClass<?> ctClass, boolean isStaticRegistration) {
        ArrayList<String> results;
        block16: {
            results = new ArrayList<String>();
            this.resolvedComponentsTxtPath = this.getComponentsTxtPath(ctClass);
            if (Files.exists(this.resolvedComponentsTxtPath, new LinkOption[0])) {
                this.componentsDeclarationLocation = this.resolvedComponentsTxtPath.toString();
                try (Stream<String> stream = Files.lines(this.resolvedComponentsTxtPath);){
                    stream.forEach(line -> {
                        if (line.trim().length() > 0) {
                            try {
                                String[] chunks = line.split(":");
                                String componentName = chunks.length > 1 ? chunks[1] : chunks[0];
                                if (results.contains(componentName)) {
                                    this.registerError(String.format("Component [%s] is registered several times in [%s]", componentName, this.resolvedComponentsTxtPath.toAbsolutePath()));
                                }
                                results.add(componentName);
                            }
                            catch (Exception e) {
                                throw new SpoonException(String.format("Invalid format [%s] in [%s]", line, this.resolvedComponentsTxtPath), (Throwable)e);
                            }
                        }
                    });
                    break block16;
                }
                catch (IOException e) {
                    throw new SpoonException(String.format("Failed to read the [%s] file", this.resolvedComponentsTxtPath), (Throwable)e);
                }
            }
            if (isStaticRegistration) {
                throw new SpoonException(String.format("There is no [%s] file and thus Component [%s] isn't declared! Consider adding a components.txt file or if it is normal use the \"staticRegistration\" parameter as in \"@Component(staticRegistration = false)\"", this.resolvedComponentsTxtPath.toAbsolutePath(), qualifiedName));
            }
        }
        return results;
    }

    private Path getComponentsTxtPath(CtClass<?> ctClass) {
        String path = this.componentsTxtPath;
        if (path == null) {
            path = "target/classes/META-INF/components.txt";
        }
        return Paths.get(this.computeMavenModulePath(ctClass), path);
    }

    private String computeMavenModulePath(CtClass<?> ctClass) {
        int levels = StringUtils.countMatches((CharSequence)ctClass.getQualifiedName(), (CharSequence)".") + 1;
        File sourcePath = ctClass.getPosition().getFile();
        for (int i = 0; i < levels + 3; ++i) {
            sourcePath = sourcePath.getParentFile();
        }
        return sourcePath.getPath();
    }
}

