/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.spoon;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.xwiki.tool.spoon.AbstractXWikiProcessor;
import org.xwiki.tool.spoon.SpoonUtils;
import spoon.processing.Property;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.reference.CtTypeReference;

public class InjectAnnotationProcessor
extends AbstractXWikiProcessor<CtAnnotation<? extends Annotation>> {
    private static final List<String> SPECIAL_INJECT_INTERFACES = Arrays.asList("org.slf4j.Logger", "java.util.List", "java.util.Map", "javax.inject.Provider", "org.xwiki.component.descriptor.ComponentDescriptor");
    @Property
    private List<String> excludedFieldTypes;

    public void process(CtAnnotation<? extends Annotation> ctAnnotation) {
        if (ctAnnotation.getAnnotationType().getQualifiedName().equals("javax.inject.Inject")) {
            CtElement element = ctAnnotation.getAnnotatedElement();
            if (element instanceof CtField) {
                CtField ctField = (CtField)element;
                if (!this.isExcluded(ctField)) {
                    this.process(ctField);
                }
            } else {
                this.registerError(String.format("Only fields should use the @Inject annotation. Problem at %s", element.getPosition()));
            }
        }
    }

    private void process(CtField<?> ctField) {
        if (!this.isValidInterface(ctField.getType()) && !this.isComponentAnnotationWithRoleToSelf(ctField.getType())) {
            this.registerError(String.format("You must inject a component role. Got [%s] at %s", ctField.getType(), ctField.getPosition()));
        }
    }

    private boolean isExcluded(CtField<?> ctField) {
        return this.excludedFieldTypes != null && this.excludedFieldTypes.contains(ctField.getType().getQualifiedName());
    }

    private boolean isValidInterface(CtTypeReference<?> ctTypeReference) {
        return ctTypeReference.isInterface() && (SPECIAL_INJECT_INTERFACES.contains(ctTypeReference.getQualifiedName()) || this.hasRoleAnnotation(ctTypeReference));
    }

    private boolean isComponentAnnotationWithRoleToSelf(CtTypeReference<?> ctTypeReference) {
        CtExpression ctElement;
        boolean result = false;
        Optional<CtAnnotation<? extends Annotation>> ctAnnotation = SpoonUtils.getAnnotation(ctTypeReference, "org.xwiki.component.annotation.Component");
        if (ctAnnotation.isPresent() && (ctElement = ctAnnotation.get().getValue("roles")) != null && ctElement.getReferencedTypes().contains(ctTypeReference)) {
            result = true;
        }
        return result;
    }

    private boolean hasRoleAnnotation(CtTypeReference<?> ctTypeReference) {
        return SpoonUtils.hasAnnotation(ctTypeReference, "org.xwiki.component.annotation.Role") || SpoonUtils.hasAnnotation(ctTypeReference, "org.xwiki.component.annotation.ComponentRole");
    }
}

