/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.spoon;

import org.xwiki.tool.spoon.AbstractXWikiProcessor;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.reference.CtTypeReference;

public class JUnit5JUnit4Processor
extends AbstractXWikiProcessor<CtClass<?>> {
    public void process(CtClass<?> ctClass) {
        boolean hasJunit5Types = false;
        boolean hasJunit4Types = false;
        for (CtTypeReference typeReference : ctClass.getReferencedTypes()) {
            if (typeReference.getQualifiedName().startsWith("org.junit.jupiter") || typeReference.getQualifiedName().startsWith("org.junit.platform")) {
                hasJunit5Types = true;
                if (!hasJunit4Types) continue;
                break;
            }
            if (!typeReference.getQualifiedName().startsWith("org.junit")) continue;
            hasJunit4Types = true;
            if (!hasJunit5Types) continue;
            break;
        }
        if (hasJunit4Types && hasJunit5Types) {
            this.registerError(String.format("There's a mix of JUnit4 and JUnit5 APIs at [%s]", ctClass.getPosition()));
        }
    }
}

